/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.service;

import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppServiceWrapper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.trash.service.TrashEntryService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class TrashEntryDLAppServiceWrapper
extends DLAppServiceWrapper {
    @Reference
    private RepositoryProvider _repositoryProvider;
    @Reference
    private TrashEntryService _trashEntryService;

    public void deleteFolder(long folderId) throws PortalException {
        TrashCapability trashCapability;
        Repository repository = this._repositoryProvider.getFolderRepository(folderId);
        Folder folder = repository.getFolder(folderId);
        if (repository.isCapabilityProvided(TrashCapability.class) && (trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class)).isInTrash(folder)) {
            this._trashEntryService.deleteEntry(DLFolderConstants.getClassName(), folder.getFolderId());
            return;
        }
        super.deleteFolder(folderId);
    }

    public void deleteFolder(long repositoryId, long parentFolderId, String name) throws PortalException {
        TrashCapability trashCapability;
        Repository repository = this._getRepository(repositoryId);
        Folder folder = repository.getFolder(parentFolderId, name);
        if (repository.isCapabilityProvided(TrashCapability.class) && (trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class)).isInTrash(folder)) {
            this._trashEntryService.deleteEntry(DLFolderConstants.getClassName(), folder.getFolderId());
            return;
        }
        super.deleteFolder(repositoryId, parentFolderId, name);
    }

    private Repository _getRepository(long repositoryId) throws PortalException {
        try {
            return this._repositoryProvider.getRepository(repositoryId);
        }
        catch (InvalidRepositoryIdException invalidRepositoryIdException) {
            throw new NoSuchGroupException(StringBundler.concat((Object[])new Object[]{"No Group exists with the key {repositoryId=", repositoryId, "}"}), (Throwable)invalidRepositoryIdException);
        }
    }
}

