/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.asset.auto.tagger.text.extractor;

import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.TextExtractor;
import java.io.InputStream;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={com.liferay.asset.auto.tagger.text.extractor.TextExtractor.class})
public class FileEntryTextExtractor
implements com.liferay.asset.auto.tagger.text.extractor.TextExtractor<FileEntry> {
    private static final Log _log = LogFactoryUtil.getLog(FileEntryTextExtractor.class);
    @Reference
    private TextExtractor _textExtractor;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String extract(FileEntry fileEntry, Locale locale) {
        try {
            FileVersion fileVersion = fileEntry.getFileVersion();
            try (InputStream inputStream = fileVersion.getContentStream(false);){
                String string = this._textExtractor.extractText(inputStream, -1);
                return string;
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return null;
        }
    }

    public String getClassName() {
        return DLFileEntryConstants.getClassName();
    }
}

