/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.view.count.model.listener;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.index.UpdateDocumentIndexWriter;
import com.liferay.portal.search.indexer.BaseModelDocumentFactory;
import com.liferay.view.count.model.ViewCountEntry;
import com.liferay.view.count.model.listener.ViewCountEntryModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ViewCountEntryModelListener.class})
public class DLFileEntryViewCountEntryModelListener
implements ViewCountEntryModelListener {
    @Reference
    private BaseModelDocumentFactory _baseModelDocumentFactory;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private UpdateDocumentIndexWriter _updateDocumentIndexWriter;

    public String getModelClassName() {
        return DLFileEntry.class.getName();
    }

    public void onAfterIncrement(ViewCountEntry viewCountEntry) {
        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(viewCountEntry.getClassPK());
        if (dlFileEntry == null) {
            return;
        }
        Document document = this._baseModelDocumentFactory.createDocument((BaseModel)dlFileEntry);
        document.addNumber("readCount", viewCountEntry.getViewCount());
        document.addNumber("viewCount", viewCountEntry.getViewCount());
        this._updateDocumentIndexWriter.updateDocumentPartially(dlFileEntry.getCompanyId(), document, false);
    }
}

