/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.model.listener;

import com.liferay.document.library.exception.DLStorageQuotaExceededException;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.service.DLStorageQuotaLocalService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.util.PortalInstances;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class DLStorageQuotaDLFileVersionModelListener
extends BaseModelListener<DLFileVersion> {
    @Reference
    private DLStorageQuotaLocalService _dlStorageQuotaLocalService;

    public void onAfterCreate(DLFileVersion dlFileVersion) throws ModelListenerException {
        this._dlStorageQuotaLocalService.incrementStorageSize(dlFileVersion.getCompanyId(), dlFileVersion.getSize());
    }

    public void onAfterRemove(DLFileVersion dlFileVersion) throws ModelListenerException {
        if (PortalInstances.isCurrentCompanyInDeletionProcess()) {
            return;
        }
        this._dlStorageQuotaLocalService.incrementStorageSize(dlFileVersion.getCompanyId(), -dlFileVersion.getSize());
    }

    public void onBeforeCreate(DLFileVersion dlFileVersion) throws ModelListenerException {
        try {
            this._dlStorageQuotaLocalService.validateStorageQuota(dlFileVersion.getCompanyId(), dlFileVersion.getSize());
        }
        catch (DLStorageQuotaExceededException dlStorageQuotaExceededException) {
            ReflectionUtil.throwException((Throwable)dlStorageQuotaExceededException);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }
}

