/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.service;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceWrapper;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.comparator.DLFileVersionVersionComparator;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.RepositoryEventTriggerCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.event.TrashRepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModel;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileShortcut;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portlet.documentlibrary.util.DLAppUtil;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class TrashEntryDLAppHelperLocalServiceWrapper
extends DLAppHelperLocalServiceWrapper {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private DLAppHelperLocalService _dlAppHelperLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileShortcutLocalService _dlFileShortcutLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private TrashVersionLocalService _trashVersionLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public void moveDependentsToTrash(DLFolder dlFolder) throws PortalException {
        this.trashOrRestoreFolder(dlFolder, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry moveFileEntryFromTrash(long userId, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException {
        boolean hasLock = this._dlFileEntryLocalService.hasFileEntryLock(userId, fileEntry.getFileEntryId(), fileEntry.getFolderId());
        if (!hasLock) {
            this._dlFileEntryLocalService.lockFileEntry(userId, fileEntry.getFileEntryId());
        }
        try {
            FileEntry fileEntry2 = this.doMoveFileEntryFromTrash(userId, fileEntry, newFolderId, serviceContext);
            return fileEntry2;
        }
        finally {
            if (!hasLock) {
                this._dlFileEntryLocalService.unlockFileEntry(fileEntry.getFileEntryId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry moveFileEntryToTrash(long userId, FileEntry fileEntry) throws PortalException {
        boolean hasLock = this._dlFileEntryLocalService.hasFileEntryLock(userId, fileEntry.getFileEntryId(), fileEntry.getFolderId());
        if (!hasLock) {
            this._dlFileEntryLocalService.lockFileEntry(userId, fileEntry.getFileEntryId());
        }
        try {
            if (fileEntry.isCheckedOut()) {
                this._dlFileEntryLocalService.cancelCheckOut(userId, fileEntry.getFileEntryId());
            }
            FileEntry fileEntry2 = this.doMoveFileEntryToTrash(userId, fileEntry);
            return fileEntry2;
        }
        finally {
            if (!hasLock) {
                this._dlFileEntryLocalService.unlockFileEntry(fileEntry.getFileEntryId());
            }
        }
    }

    public FileShortcut moveFileShortcutFromTrash(long userId, FileShortcut fileShortcut, long newFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileShortcut dlFileShortcut = (DLFileShortcut)fileShortcut.getModel();
        if (!dlFileShortcut.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (this._trashHelper.isInTrashExplicitly((TrashedModel)dlFileShortcut)) {
            this.restoreFileShortcutFromTrash(userId, fileShortcut);
        } else {
            TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this._dlFileShortcutLocalService.updateStatus(userId, fileShortcut.getFileShortcutId(), status, new ServiceContext());
            if (trashVersion != null) {
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)fileShortcut.getToTitle());
            SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)fileShortcut, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        }
        return this._dlAppLocalService.updateFileShortcut(userId, fileShortcut.getFileShortcutId(), newFolderId, fileShortcut.getToFileEntryId(), serviceContext);
    }

    public FileShortcut moveFileShortcutToTrash(long userId, FileShortcut fileShortcut) throws PortalException {
        DLFileShortcut dlFileShortcut = (DLFileShortcut)fileShortcut.getModel();
        if (dlFileShortcut.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = dlFileShortcut.getStatus();
        dlFileShortcut = this._dlFileShortcutLocalService.updateStatus(userId, fileShortcut.getFileShortcutId(), 8, new ServiceContext());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)this._trashHelper.getOriginalTitle(fileShortcut.getToTitle()));
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)fileShortcut, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        this._trashEntryLocalService.addTrashEntry(userId, fileShortcut.getGroupId(), DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId(), fileShortcut.getUuid(), null, oldStatus, null, null);
        return new LiferayFileShortcut(dlFileShortcut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder moveFolderFromTrash(long userId, Folder folder, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        boolean hasLock = this._dlFolderLocalService.hasFolderLock(userId, folder.getFolderId());
        Lock lock = null;
        if (!hasLock) {
            lock = this._dlFolderLocalService.lockFolder(userId, folder.getFolderId());
        }
        try {
            Folder folder2 = this.doMoveFolderFromTrash(userId, folder, parentFolderId, serviceContext);
            return folder2;
        }
        finally {
            if (!hasLock) {
                this._dlFolderLocalService.unlockFolder(folder.getFolderId(), lock.getUuid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder moveFolderToTrash(long userId, Folder folder) throws PortalException {
        boolean hasLock = this._dlFolderLocalService.hasFolderLock(userId, folder.getFolderId());
        Lock lock = null;
        if (!hasLock) {
            lock = this._dlFolderLocalService.lockFolder(userId, folder.getFolderId());
        }
        try {
            Folder folder2 = this.doMoveFolderToTrash(userId, folder);
            return folder2;
        }
        finally {
            if (!hasLock) {
                this._dlFolderLocalService.unlockFolder(folder.getFolderId(), lock.getUuid());
            }
        }
    }

    public void restoreDependentsFromTrash(DLFolder dlFolder) throws PortalException {
        this.trashOrRestoreFolder(dlFolder, false);
    }

    public void restoreFileEntryFromTrash(long userId, FileEntry fileEntry) throws PortalException {
        this.restoreFileEntryFromTrash(userId, fileEntry.getFolderId(), fileEntry);
    }

    public void restoreFileEntryFromTrash(long userId, long newFolderId, FileEntry fileEntry) throws PortalException {
        String originalFileName;
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        if (!dlFileEntry.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!DLAppHelperThreadLocal.isEnabled()) {
            this._dlFileEntryLocalService.updateStatus(userId, fileVersion.getFileVersionId(), 0, new ServiceContext(), new HashMap());
            return;
        }
        String originalTitle = this._trashHelper.getOriginalTitle(dlFileEntry.getTitle());
        String title = this._dlFileEntryLocalService.getUniqueTitle(dlFileEntry.getGroupId(), newFolderId, dlFileEntry.getFileEntryId(), originalTitle, dlFileEntry.getExtension());
        String fileName = originalFileName = this._trashHelper.getOriginalTitle(dlFileEntry.getTitle(), "fileName");
        if (!StringUtil.equals((String)title, (String)originalTitle)) {
            fileName = DLUtil.getSanitizedFileName((String)title, (String)DLAppUtil.getExtension((String)title, (String)originalFileName));
        }
        dlFileEntry.setFileName(fileName);
        dlFileEntry.setTitle(title);
        dlFileEntry = this._dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
        DLFileVersion dlFileVersion = (DLFileVersion)fileVersion.getModel();
        dlFileVersion.setFileName(fileName);
        dlFileVersion.setTitle(title);
        dlFileVersion = this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        this._dlFileEntryLocalService.updateStatus(userId, dlFileEntry, dlFileVersion, trashEntry.getStatus(), new ServiceContext(), new HashMap());
        this._dlFileShortcutLocalService.enableFileShortcuts(fileEntry.getFileEntryId());
        this.triggerRepositoryEvent(fileEntry.getRepositoryId(), TrashRepositoryEventType.EntryRestored.class, FileEntry.class, fileEntry);
        List trashVersions = this._trashVersionLocalService.getVersions(trashEntry.getEntryId());
        for (TrashVersion trashVersion : trashVersions) {
            DLFileVersion trashDLFileVersion = this._dlFileVersionLocalService.getDLFileVersion(trashVersion.getClassPK());
            trashDLFileVersion.setStatus(trashVersion.getStatus());
            this._dlFileVersionLocalService.updateDLFileVersion(trashDLFileVersion);
        }
        this._trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)fileEntry.getTitle());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)fileEntry, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
    }

    public void restoreFileShortcutFromTrash(long userId, FileShortcut fileShortcut) throws PortalException {
        DLFileShortcut dlFileShortcut = (DLFileShortcut)fileShortcut.getModel();
        if (!dlFileShortcut.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId());
        this._dlFileShortcutLocalService.updateStatus(userId, fileShortcut.getFileShortcutId(), trashEntry.getStatus(), new ServiceContext());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)fileShortcut.getToTitle());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)fileShortcut, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        this._trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
    }

    public void restoreFolderFromTrash(long userId, Folder folder) throws PortalException {
        DLFolder dlFolder = (DLFolder)folder.getModel();
        if (!dlFolder.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        String originalName = this._trashHelper.getOriginalTitle(dlFolder.getName());
        dlFolder.setName(this._dlFolderLocalService.getUniqueFolderName(folder.getUuid(), folder.getGroupId(), folder.getParentFolderId(), originalName, 2));
        dlFolder = this._dlFolderLocalService.updateDLFolder(dlFolder);
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(DLFolder.class.getName(), dlFolder.getFolderId());
        this._dlFolderLocalService.updateStatus(userId, folder.getFolderId(), trashEntry.getStatus(), new HashMap(), new ServiceContext());
        this.restoreDependentsFromTrash(dlFolder);
        this.triggerRepositoryEvent(folder.getRepositoryId(), TrashRepositoryEventType.EntryRestored.class, Folder.class, folder);
        this._trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)folder.getName());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)folder, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
    }

    protected FileEntry doMoveFileEntryFromTrash(long userId, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        if (!dlFileEntry.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (this._trashHelper.isInTrashExplicitly((TrashedModel)dlFileEntry)) {
            this.restoreFileEntryFromTrash(userId, newFolderId, fileEntry);
            if (fileEntry.getFolderId() != newFolderId) {
                fileEntry = this._dlAppLocalService.moveFileEntry(userId, fileEntry.getFileEntryId(), newFolderId, serviceContext);
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
            indexer.reindex((Object)((DLFileEntry)fileEntry.getModel()));
            return fileEntry;
        }
        List dlFileVersions = this._dlFileVersionLocalService.getFileVersions(fileEntry.getFileEntryId(), 8);
        dlFileVersions = ListUtil.sort((List)dlFileVersions, (Comparator)DLFileVersionVersionComparator.getInstance((boolean)false));
        LiferayFileVersion fileVersion = new LiferayFileVersion((DLFileVersion)dlFileVersions.get(0));
        TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(DLFileVersion.class.getName(), fileVersion.getFileVersionId());
        int oldStatus = 0;
        if (trashVersion != null) {
            oldStatus = trashVersion.getStatus();
        }
        this._dlFileEntryLocalService.updateStatus(userId, dlFileEntry, (DLFileVersion)dlFileVersions.get(0), oldStatus, serviceContext, new HashMap());
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            trashVersion = this._trashVersionLocalService.fetchVersion(DLFileVersion.class.getName(), dlFileVersion.getFileVersionId());
            oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            dlFileVersion.setStatus(oldStatus);
            this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
            if (trashVersion == null) continue;
            this._trashVersionLocalService.deleteTrashVersion(trashVersion);
        }
        if (DLAppHelperThreadLocal.isEnabled()) {
            this._dlFileShortcutLocalService.enableFileShortcuts(fileEntry.getFileEntryId());
        }
        fileEntry = this._dlAppLocalService.moveFileEntry(userId, fileEntry.getFileEntryId(), newFolderId, serviceContext);
        this.triggerRepositoryEvent(fileEntry.getRepositoryId(), TrashRepositoryEventType.EntryRestored.class, FileEntry.class, fileEntry);
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)fileEntry.getTitle());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)fileEntry, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        indexer.reindex((Object)((DLFileEntry)fileEntry.getModel()));
        return fileEntry;
    }

    protected FileEntry doMoveFileEntryToTrash(long userId, FileEntry fileEntry) throws PortalException {
        if (fileEntry.isInTrash()) {
            throw new TrashEntryException();
        }
        List dlFileVersions = this._dlFileVersionLocalService.getFileVersions(fileEntry.getFileEntryId(), -1);
        dlFileVersions = ListUtil.sort((List)dlFileVersions, (Comparator)DLFileVersionVersionComparator.getInstance((boolean)false));
        List<Object> dlFileVersionStatusOVPs = new ArrayList();
        if (dlFileVersions != null && !dlFileVersions.isEmpty()) {
            dlFileVersionStatusOVPs = this.getDlFileVersionStatuses(dlFileVersions);
        }
        FileVersion fileVersion = fileEntry.getLatestFileVersion(true);
        this._dlFileEntryLocalService.updateStatus(userId, fileVersion.getFileVersionId(), 8, new ServiceContext(), new HashMap());
        if (DLAppHelperThreadLocal.isEnabled()) {
            this._dlFileShortcutLocalService.disableFileShortcuts(fileEntry.getFileEntryId());
            this.triggerRepositoryEvent(fileEntry.getRepositoryId(), TrashRepositoryEventType.EntryTrashed.class, FileEntry.class, fileEntry);
        }
        dlFileVersions = this._dlFileVersionLocalService.getFileVersions(fileEntry.getFileEntryId(), -1);
        for (DLFileVersion curDLFileVersion : dlFileVersions) {
            curDLFileVersion.setStatus(8);
            this._dlFileVersionLocalService.updateDLFileVersion(curDLFileVersion);
        }
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return fileEntry;
        }
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        DLFileVersion oldDLFileVersion = (DLFileVersion)fileVersion.getModel();
        int oldDLFileVersionStatus = oldDLFileVersion.getStatus();
        TrashEntry trashEntry = this._trashEntryLocalService.addTrashEntry(userId, dlFileEntry.getGroupId(), DLFileEntryConstants.getClassName(), dlFileEntry.getFileEntryId(), dlFileEntry.getUuid(), dlFileEntry.getClassName(), oldDLFileVersionStatus, dlFileVersionStatusOVPs, UnicodePropertiesBuilder.put((String)"fileName", (String)dlFileEntry.getFileName()).put("title", dlFileEntry.getTitle()).build());
        String trashTitle = this._trashHelper.getTrashTitle(trashEntry.getEntryId());
        dlFileEntry.setFileName(trashTitle);
        dlFileEntry.setTitle(trashTitle);
        dlFileEntry = this._dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        indexer.reindex((Object)dlFileEntry);
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)this._trashHelper.getOriginalTitle(fileEntry.getTitle()));
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)fileEntry, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        int oldStatus = fileVersion.getStatus();
        if (oldStatus == 1) {
            this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(fileVersion.getCompanyId(), fileVersion.getGroupId(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId());
        }
        return fileEntry;
    }

    protected Folder doMoveFolderFromTrash(long userId, Folder folder, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        DLFolder dlFolder = (DLFolder)folder.getModel();
        if (!dlFolder.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (this._trashHelper.isInTrashExplicitly((TrashedModel)dlFolder)) {
            this.restoreFolderFromTrash(userId, folder);
        } else {
            TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(DLFolder.class.getName(), dlFolder.getFolderId());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this._dlFolderLocalService.updateStatus(userId, folder.getFolderId(), status, new HashMap(), new ServiceContext());
            if (trashVersion != null) {
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            this.restoreDependentsFromTrash(dlFolder);
            this.triggerRepositoryEvent(folder.getRepositoryId(), TrashRepositoryEventType.EntryRestored.class, Folder.class, folder);
            JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)folder.getName());
            SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)folder, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        }
        return this._dlAppLocalService.moveFolder(userId, folder.getFolderId(), parentFolderId, serviceContext);
    }

    protected Folder doMoveFolderToTrash(long userId, Folder folder) throws PortalException {
        DLFolder dlFolder = (DLFolder)folder.getModel();
        if (dlFolder.isInTrash()) {
            throw new TrashEntryException();
        }
        dlFolder = this._dlFolderLocalService.updateStatus(userId, folder.getFolderId(), 8, new HashMap(), new ServiceContext());
        TrashEntry trashEntry = this._trashEntryLocalService.addTrashEntry(userId, dlFolder.getGroupId(), DLFolderConstants.getClassName(), dlFolder.getFolderId(), dlFolder.getUuid(), null, 0, null, UnicodePropertiesBuilder.put((String)"title", (String)dlFolder.getName()).build());
        dlFolder.setName(this._trashHelper.getTrashTitle(trashEntry.getEntryId()));
        dlFolder = this._dlFolderLocalService.updateDLFolder(dlFolder);
        this.moveDependentsToTrash(dlFolder);
        this.triggerRepositoryEvent(folder.getRepositoryId(), TrashRepositoryEventType.EntryTrashed.class, Folder.class, folder);
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)folder.getName());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)folder, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFolder.class);
        indexer.reindex((Object)dlFolder);
        return new LiferayFolder(dlFolder);
    }

    protected List<ObjectValuePair<Long, Integer>> getDlFileVersionStatuses(List<DLFileVersion> dlFileVersions) {
        ArrayList<ObjectValuePair<Long, Integer>> dlFileVersionStatusOVPs = new ArrayList<ObjectValuePair<Long, Integer>>(dlFileVersions.size());
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            int status = dlFileVersion.getStatus();
            if (status == 1) {
                status = 2;
            }
            ObjectValuePair dlFileVersionStatusOVP = new ObjectValuePair((Object)dlFileVersion.getFileVersionId(), (Object)status);
            dlFileVersionStatusOVPs.add((ObjectValuePair<Long, Integer>)dlFileVersionStatusOVP);
        }
        return dlFileVersionStatusOVPs;
    }

    protected void trashOrRestoreFolder(DLFolder dlFolder, boolean moveToTrash) throws PortalException {
        TrashEntry trashEntry = null;
        if (moveToTrash) {
            trashEntry = this._trashEntryLocalService.getEntry(DLFolderConstants.getClassName(), dlFolder.getFolderId());
        }
        long dlFileEntryClassNameId = this._classNameLocalService.getClassNameId(DLFileEntry.class);
        List dlFileEntries = this._dlFileEntryLocalService.getFileEntriesByClassNameIdAndTreePath(dlFileEntryClassNameId, dlFolder.getTreePath());
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            this._assetEntryLocalService.updateVisible(DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), !moveToTrash);
        }
        long dlFolderClassNameId = this._classNameLocalService.getClassNameId(DLFolder.class);
        List<Object> dlFolders = this._dlFolderLocalService.getFolders(dlFolderClassNameId, dlFolder.getTreePath());
        for (DLFolder curDLFolder : dlFolders) {
            this._assetEntryLocalService.updateVisible(DLFolder.class.getName(), curDLFolder.getFolderId(), !moveToTrash);
        }
        dlFolders = moveToTrash ? this._dlFolderLocalService.getNotInTrashFolders(dlFolder.getGroupId(), false, this._customSQL.keywords(dlFolder.getTreePath(), WildcardMode.TRAILING)[0], false) : this._dlFolderLocalService.getFolders(dlFolder.getGroupId(), false, this._customSQL.keywords(dlFolder.getTreePath(), WildcardMode.TRAILING)[0], false);
        if (!dlFolders.contains(dlFolder)) {
            dlFolders = new ArrayList<DLFolder>(dlFolders);
            dlFolders.add(dlFolder);
        }
        for (DLFolder childDLFolder : dlFolders) {
            this.trashOrRestoreFolder(dlFolder, childDLFolder, moveToTrash, trashEntry);
        }
    }

    protected void trashOrRestoreFolder(DLFolder dlFolder, DLFolder childDLFolder, boolean moveToTrash, TrashEntry trashEntry) throws PortalException {
        ArrayList<Long> dlFileEntryIds = new ArrayList<Long>();
        List dlFileEntries = this._dlFileEntryLocalService.getFileEntries(childDLFolder.getGroupId(), childDLFolder.getFolderId());
        for (Object dlFileEntry : dlFileEntries) {
            if (moveToTrash ? this._trashHelper.isInTrashExplicitly((TrashedModel)dlFileEntry) : !this._trashHelper.isInTrashImplicitly((TrashedModel)dlFileEntry)) continue;
            this._dlFileShortcutLocalService.updateFileShortcutsActive(dlFileEntry.getFileEntryId(), !moveToTrash);
            List dlFileVersions = null;
            dlFileVersions = moveToTrash ? this._dlFileVersionLocalService.getFileVersions(dlFileEntry.getFileEntryId(), -1) : this._dlFileVersionLocalService.getFileVersions(dlFileEntry.getFileEntryId(), 8);
            for (DLFileVersion dlFileVersion : dlFileVersions) {
                if (moveToTrash) {
                    int oldStatus = dlFileVersion.getStatus();
                    dlFileVersion.setStatus(8);
                    dlFileVersion = this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
                    if (oldStatus != 0) {
                        int newStatus = oldStatus;
                        if (oldStatus == 1) {
                            newStatus = 2;
                        }
                        this._trashVersionLocalService.addTrashVersion(trashEntry.getEntryId(), DLFileVersion.class.getName(), dlFileVersion.getFileVersionId(), newStatus, null);
                    }
                    if (oldStatus != 1) continue;
                    this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(dlFileVersion.getCompanyId(), dlFileVersion.getGroupId(), DLFileEntryConstants.getClassName(), dlFileVersion.getFileVersionId());
                    continue;
                }
                TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(DLFileVersion.class.getName(), dlFileVersion.getFileVersionId());
                int oldStatus = 0;
                if (trashVersion != null) {
                    oldStatus = trashVersion.getStatus();
                }
                dlFileVersion.setStatus(oldStatus);
                this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
                if (trashVersion == null) continue;
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            dlFileEntryIds.add(dlFileEntry.getFileEntryId());
        }
        if (!dlFileEntryIds.isEmpty()) {
            this._dlAppHelperLocalService.reindex(dlFolder.getCompanyId(), dlFileEntryIds);
        }
        List dlFileShortcuts = this._dlFileShortcutLocalService.getFileShortcuts(childDLFolder.getGroupId(), childDLFolder.getFolderId());
        for (DLFileShortcut dlFileShortcut : dlFileShortcuts) {
            if (moveToTrash) {
                if (this._trashHelper.isInTrashExplicitly((TrashedModel)dlFileShortcut)) continue;
                int oldStatus = dlFileShortcut.getStatus();
                dlFileShortcut.setStatus(8);
                dlFileShortcut = this._dlFileShortcutLocalService.updateDLFileShortcut(dlFileShortcut);
                if (oldStatus == 0) continue;
                this._trashVersionLocalService.addTrashVersion(trashEntry.getEntryId(), DLFileShortcutConstants.getClassName(), dlFileShortcut.getFileShortcutId(), oldStatus, null);
                continue;
            }
            if (!this._trashHelper.isInTrashImplicitly((TrashedModel)dlFileShortcut)) continue;
            TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(DLFileShortcutConstants.getClassName(), dlFileShortcut.getFileShortcutId());
            int oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            dlFileShortcut.setStatus(oldStatus);
            this._dlFileShortcutLocalService.updateDLFileShortcut(dlFileShortcut);
            if (trashVersion == null) continue;
            this._trashVersionLocalService.deleteTrashVersion(trashVersion);
        }
        if (childDLFolder.equals(dlFolder)) {
            return;
        }
        if (moveToTrash) {
            if (this._trashHelper.isInTrashExplicitly((TrashedModel)childDLFolder)) {
                return;
            }
            int oldStatus = childDLFolder.getStatus();
            childDLFolder.setStatus(8);
            childDLFolder = this._dlFolderLocalService.updateDLFolder(childDLFolder);
            if (oldStatus != 0) {
                this._trashVersionLocalService.addTrashVersion(trashEntry.getEntryId(), DLFolder.class.getName(), childDLFolder.getFolderId(), oldStatus, null);
            }
        } else {
            if (!this._trashHelper.isInTrashImplicitly((TrashedModel)childDLFolder)) {
                return;
            }
            TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(DLFolder.class.getName(), childDLFolder.getFolderId());
            int oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            childDLFolder.setStatus(oldStatus);
            childDLFolder = this._dlFolderLocalService.updateDLFolder(childDLFolder);
            if (trashVersion != null) {
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFolder.class);
        indexer.reindex((Object)childDLFolder);
    }

    protected <T extends RepositoryModel<T>> void triggerRepositoryEvent(long repositoryId, Class<? extends RepositoryEventType> repositoryEventType, Class<T> modelClass, T target) throws PortalException {
        Repository repository = RepositoryProviderUtil.getRepository((long)repositoryId);
        if (repository.isCapabilityProvided(RepositoryEventTriggerCapability.class)) {
            RepositoryEventTriggerCapability repositoryEventTriggerCapability = (RepositoryEventTriggerCapability)repository.getCapability(RepositoryEventTriggerCapability.class);
            repositoryEventTriggerCapability.trigger(repositoryEventType, modelClass, target);
        }
    }
}

