/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.security.permission.resource;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryModel;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourcePermissionCheckerUtil;
import com.liferay.portal.kernel.security.permission.resource.BaseModelResourcePermissionWrapper;
import com.liferay.portal.kernel.security.permission.resource.DynamicInheritancePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.StagedModelPermissionLogic;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.sharing.security.permission.resource.SharingModelResourcePermissionConfigurator;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={ModelResourcePermission.class})
public class DLFileEntryModelResourcePermissionWrapper
extends BaseModelResourcePermissionWrapper<DLFileEntry> {
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFolder)")
    private ModelResourcePermission<DLFolder> _dlFolderModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.document.library)")
    private PortletResourcePermission _portletResourcePermission;
    private ServiceTrackerList<ModelResourcePermissionFactory.ModelResourcePermissionConfigurator> _serviceTrackerList;
    @Reference
    private SharingModelResourcePermissionConfigurator _sharingModelResourcePermissionConfigurator;
    @Reference
    private StagingPermission _stagingPermission;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, ModelResourcePermissionFactory.ModelResourcePermissionConfigurator.class, (String)"(model.class.name=com.liferay.document.library.kernel.model.DLFileEntry)");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }

    protected ModelResourcePermission<DLFileEntry> doGetModelResourcePermission() {
        return ModelResourcePermissionFactory.create(DLFileEntry.class, DLFileEntryModel::getFileEntryId, arg_0 -> ((DLFileEntryLocalService)this._dlFileEntryLocalService).getDLFileEntry(arg_0), (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            this._serviceTrackerList.forEach(modelResourcePermissionConfigurator -> modelResourcePermissionConfigurator.configureModelResourcePermissionLogics(modelResourcePermission, consumer));
            consumer.accept(new StagedModelPermissionLogic(this._stagingPermission, "com_liferay_document_library_web_portlet_DLPortlet", DLFileEntryModel::getFileEntryId));
            consumer.accept(new DLFileEntryWorkflowedModelResourcePermissionLogic(modelResourcePermission));
            this._sharingModelResourcePermissionConfigurator.configure(modelResourcePermission, consumer);
            consumer.accept((permissionChecker, name, fileEntry, actionId) -> {
                String className = fileEntry.getClassName();
                long classPK = fileEntry.getClassPK();
                if (Validator.isNull((String)className) || classPK <= 0L) {
                    return null;
                }
                String relatedModelActionId = this._getRelatedModelActionId(actionId);
                Boolean hasResourcePermission = ResourcePermissionCheckerUtil.containsResourcePermission((PermissionChecker)permissionChecker, (String)className, (long)classPK, (String)relatedModelActionId);
                if (hasResourcePermission != null && !hasResourcePermission.booleanValue()) {
                    return false;
                }
                Boolean hasBaseModelPermission = ModelResourcePermissionUtil.contains((PermissionChecker)permissionChecker, (long)fileEntry.getGroupId(), (String)className, (long)classPK, (String)relatedModelActionId);
                if (hasBaseModelPermission != null && !hasBaseModelPermission.booleanValue()) {
                    return false;
                }
                return null;
            });
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                DynamicInheritancePermissionLogic dynamicInheritancePermissionLogic = new DynamicInheritancePermissionLogic(this._dlFolderModelResourcePermission, this._getFetchParentFunction(), true);
                consumer.accept((permissionChecker, name, model, actionId) -> {
                    if (actionId.equals("DOWNLOAD")) {
                        actionId = "VIEW";
                    }
                    return dynamicInheritancePermissionLogic.contains(permissionChecker, name, model, actionId);
                });
            }
        });
    }

    private UnsafeFunction<DLFileEntry, DLFolder, PortalException> _getFetchParentFunction() {
        return fileEntry -> {
            long folderId = fileEntry.getFolderId();
            if (0L == folderId) {
                return null;
            }
            if (fileEntry.isInTrash()) {
                return this._dlFolderLocalService.fetchDLFolder(folderId);
            }
            return this._dlFolderLocalService.getFolder(folderId);
        };
    }

    private String _getRelatedModelActionId(String actionId) {
        if (actionId.equals("DOWNLOAD")) {
            return "VIEW";
        }
        return actionId;
    }

    private class DLFileEntryWorkflowedModelResourcePermissionLogic
    implements ModelResourcePermissionLogic<DLFileEntry> {
        private final ModelResourcePermission<DLFileEntry> _modelResourcePermission;

        public Boolean contains(PermissionChecker permissionChecker, String name, DLFileEntry dlFileEntry, String actionId) throws PortalException {
            DLFileVersion fileVersion = dlFileEntry.getFileVersion();
            if (fileVersion.isDraft() || fileVersion.isScheduled()) {
                if (actionId.equals("VIEW") && !this._modelResourcePermission.contains(permissionChecker, (ClassedModel)dlFileEntry, "UPDATE")) {
                    return false;
                }
            } else if (fileVersion.isPending()) {
                Boolean hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)fileVersion.getGroupId(), (String)name, (long)fileVersion.getFileVersionId(), (String)actionId);
                if (hasPermission != null) {
                    return hasPermission;
                }
                return false;
            }
            return null;
        }

        private DLFileEntryWorkflowedModelResourcePermissionLogic(ModelResourcePermission<DLFileEntry> modelResourcePermission) {
            this._modelResourcePermission = modelResourcePermission;
        }
    }
}

