/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search.spi.model.query.contributor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={KeywordQueryContributor.class})
public class DLFileEntryKeywordQueryContributor
implements KeywordQueryContributor {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryKeywordQueryContributor.class);
    @Reference
    private QueryHelper _queryHelper;
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        if (Validator.isNull((String)keywords)) {
            this._queryHelper.addSearchLocalizedTerm(booleanQuery, searchContext, "description", false);
            this._queryHelper.addSearchTerm(booleanQuery, searchContext, "userName", false);
        }
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "ddmContent", false);
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "extension", false);
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "fileEntryTypeId", false);
        this._addSearchLocalizedTerm(booleanQuery, "content", searchContext);
        this._addSearchLocalizedTerm(booleanQuery, "title", searchContext);
        if (Validator.isNotNull((String)keywords)) {
            try {
                BooleanQueryImpl fileNameBooleanQuery = new BooleanQueryImpl();
                this._addKeywordsToFileNameBooleanQuery((BooleanQuery)fileNameBooleanQuery, keywords);
                booleanQuery.add((Query)this._getMatchQuery("fileExtension", keywords, MatchQuery.Type.PHRASE_PREFIX), BooleanClauseOccur.SHOULD);
                fileNameBooleanQuery.add((Query)this._getMatchQuery("fileName", keywords, MatchQuery.Type.PHRASE), BooleanClauseOccur.SHOULD);
                booleanQuery.add((Query)fileNameBooleanQuery, BooleanClauseOccur.SHOULD);
            }
            catch (ParseException parseException) {
                throw new SystemException((Throwable)parseException);
            }
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.addHighlightFieldNames(this._searchLocalizationHelper.getLocalizedFieldNames(new String[]{"content", "title"}, searchContext));
    }

    private void _addKeywordsToFileNameBooleanQuery(BooleanQuery fileNameBooleanQuery, String keywords) throws ParseException {
        String exactMatch = StringUtils.substringBetween((String)keywords, (String)"\"");
        if (Validator.isNull((String)exactMatch)) {
            fileNameBooleanQuery.add((Query)this._getShouldBooleanQuery(StringUtil.trim((String)keywords)), BooleanClauseOccur.MUST);
        } else {
            fileNameBooleanQuery.add((Query)this._getMatchQuery("fileName", exactMatch, MatchQuery.Type.PHRASE), BooleanClauseOccur.MUST);
            String remainingKeywords = keywords.replaceFirst(Pattern.quote("\"" + exactMatch + "\""), "");
            if (Validator.isNotNull((String)remainingKeywords)) {
                this._addKeywordsToFileNameBooleanQuery(fileNameBooleanQuery, remainingKeywords);
            }
        }
    }

    private void _addSearchLocalizedTerm(BooleanQuery booleanQuery, String fieldName, SearchContext searchContext) {
        String[] localizedFieldNames;
        String value = searchContext.getKeywords();
        if (Validator.isBlank((String)value)) {
            return;
        }
        for (String localizedFieldName : localizedFieldNames = this._searchLocalizationHelper.getLocalizedFieldNames(new String[]{fieldName}, searchContext)) {
            this._addTerm(booleanQuery, localizedFieldName, value);
        }
    }

    private void _addTerm(BooleanQuery booleanQuery, String field, String value) {
        block2: {
            try {
                booleanQuery.addTerm(field, value, false);
            }
            catch (ParseException parseException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Unable to add term field \"", field, "\" with value \"", value, "\""}), (Throwable)parseException);
            }
        }
    }

    private MatchQuery _getMatchQuery(String field, String keywords, MatchQuery.Type phrase) {
        MatchQuery matchPhraseQuery = new MatchQuery(field, keywords);
        matchPhraseQuery.setType(phrase);
        return matchPhraseQuery;
    }

    private BooleanQuery _getShouldBooleanQuery(String keyword) throws ParseException {
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        booleanQuery.add((Query)new MatchQuery("fileName", keyword), BooleanClauseOccur.SHOULD);
        booleanQuery.add((Query)this._getMatchQuery("fileName", keyword, MatchQuery.Type.PHRASE_PREFIX), BooleanClauseOccur.SHOULD);
        return booleanQuery;
    }
}

