/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.processor;

import com.liferay.document.library.configuration.DLFileEntryConfigurationProvider;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.processor.DLProcessor;
import com.liferay.document.library.kernel.processor.DLProcessorHelper;
import com.liferay.document.library.kernel.processor.DLProcessorThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.xml.Element;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLProcessorHelper.class})
public class DLProcessorHelperImpl
implements DLProcessorHelper {
    private static final Log _log = LogFactoryUtil.getLog(DLProcessorHelperImpl.class);
    private BundleContext _bundleContext;
    @Reference
    private DLFileEntryConfigurationProvider _dlFileEntryConfigurationProvider;
    private ServiceTrackerMap<String, DLProcessor> _serviceTrackerMap;

    public void cleanUp(FileEntry fileEntry) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        for (DLProcessor dlProcessor : this._serviceTrackerMap.values()) {
            if (!dlProcessor.isSupported(fileEntry.getMimeType())) continue;
            dlProcessor.cleanUp(fileEntry);
        }
    }

    public void cleanUp(FileVersion fileVersion) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        for (DLProcessor dlProcessor : this._serviceTrackerMap.values()) {
            if (!dlProcessor.isSupported(fileVersion)) continue;
            dlProcessor.cleanUp(fileVersion);
        }
    }

    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        if (fileEntry == null || fileEntry.getSize() == 0L) {
            return;
        }
        FileVersion latestFileVersion = this._getLatestFileVersion(fileEntry, true);
        if (latestFileVersion == null) {
            return;
        }
        for (DLProcessor dlProcessor : this._serviceTrackerMap.values()) {
            if (!dlProcessor.isSupported(latestFileVersion)) continue;
            dlProcessor.exportGeneratedFiles(portletDataContext, fileEntry, fileEntryElement);
        }
    }

    public DLProcessor getDLProcessor(String dlProcessorType) {
        return (DLProcessor)this._serviceTrackerMap.getService((Object)dlProcessorType);
    }

    public long getPreviewableProcessorMaxSize(long groupId) {
        return this._dlFileEntryConfigurationProvider.getGroupPreviewableProcessorMaxSize(groupId);
    }

    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        if (importedFileEntry == null || importedFileEntry.getSize() == 0L) {
            return;
        }
        FileVersion fileVersion = importedFileEntry.getFileVersion();
        if (fileVersion == null) {
            return;
        }
        for (DLProcessor dlProcessor : this._serviceTrackerMap.values()) {
            if (!dlProcessor.isSupported(fileVersion)) continue;
            dlProcessor.importGeneratedFiles(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
        }
    }

    public boolean isPreviewableSize(FileVersion fileVersion) {
        long previewableProcessorMaxSize = this._dlFileEntryConfigurationProvider.getGroupPreviewableProcessorMaxSize(fileVersion.getGroupId());
        return previewableProcessorMaxSize != 0L && (previewableProcessorMaxSize <= 0L || fileVersion.getSize() <= previewableProcessorMaxSize);
    }

    public void trigger(FileEntry fileEntry, FileVersion fileVersion) {
        this.trigger(fileEntry, fileVersion, false);
    }

    public void trigger(FileEntry fileEntry, FileVersion fileVersion, boolean trusted) {
        if (!DLProcessorThreadLocal.isEnabled() || fileEntry == null || fileEntry.getSize() == 0L) {
            return;
        }
        FileVersion latestFileVersion = this._getLatestFileVersion(fileEntry, trusted);
        if (latestFileVersion == null) {
            return;
        }
        for (DLProcessor dlProcessor : this._serviceTrackerMap.values()) {
            if (!dlProcessor.isSupported(latestFileVersion)) continue;
            dlProcessor.trigger(fileVersion, latestFileVersion);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        this._bundleContext = bundleContext;
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DLProcessor.class, (String)"type");
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this._serviceTrackerMap.close();
    }

    private FileVersion _getLatestFileVersion(FileEntry fileEntry, boolean trusted) {
        try {
            return fileEntry.getLatestFileVersion(trusted);
        }
        catch (NoSuchFileEntryException | NoSuchFileVersionException exception) {
            if (_log.isInfoEnabled()) {
                _log.info(exception);
            }
            return null;
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return null;
        }
    }
}

