/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.exportimport.data.handler;

import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileShortcut;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class FileShortcutStagedModelDataHandler
extends BaseStagedModelDataHandler<FileShortcut> {
    public static final String[] CLASS_NAMES = new String[]{DLFileShortcutConstants.getClassName(), FileShortcut.class.getName(), LiferayFileShortcut.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(FileShortcutStagedModelDataHandler.class);
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileShortcutLocalService _dlFileShortcutLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;

    public void deleteStagedModel(FileShortcut fileShortcut) throws PortalException {
        this._dlFileShortcutLocalService.deleteFileShortcut(fileShortcut.getFileShortcutId());
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        FileShortcut fileShortcut = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (fileShortcut != null) {
            this.deleteStagedModel(fileShortcut);
        }
    }

    public FileShortcut fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        try {
            DLFileShortcut dlFileShortcut = this._dlFileShortcutLocalService.getDLFileShortcutByUuidAndGroupId(uuid, groupId);
            return new LiferayFileShortcut(dlFileShortcut);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    public List<FileShortcut> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        List dlFileShortcuts = this._dlFileShortcutLocalService.getDLFileShortcutsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
        ArrayList<FileShortcut> fileShortcuts = new ArrayList<FileShortcut>();
        for (DLFileShortcut dlFileShortcut : dlFileShortcuts) {
            fileShortcuts.add((FileShortcut)new LiferayFileShortcut(dlFileShortcut));
        }
        return fileShortcuts;
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(FileShortcut fileShortcut) {
        return fileShortcut.getUuid();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, FileShortcut fileShortcut) throws Exception {
        FileEntry fileEntry = this._dlAppLocalService.getFileEntry(fileShortcut.getToFileEntryId());
        if (fileEntry.hasLock() || fileEntry.isCheckedOut()) {
            return;
        }
        if (fileShortcut.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileShortcut, (StagedModel)fileShortcut.getFolder(), (String)"parent");
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileShortcut, (StagedModel)fileEntry, (String)"strong");
        Element fileShortcutElement = portletDataContext.getExportDataElement((ClassedModel)fileShortcut);
        portletDataContext.addClassedModel(fileShortcutElement, ExportImportPathUtil.getModelPath((StagedModel)fileShortcut), (ClassedModel)fileShortcut, DLFileShortcut.class);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, FileShortcut fileShortcut) throws Exception {
        Map fileEntryIds;
        long fileEntryId;
        FileEntry importedFileEntry;
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        long folderId = MapUtil.getLong((Map)folderIds, (long)fileShortcut.getFolderId(), (long)fileShortcut.getFolderId());
        long groupId = portletDataContext.getScopeGroupId();
        if (folderId != 0L) {
            DLFolder dlFolder = this._dlFolderLocalService.getFolder(folderId);
            groupId = dlFolder.getRepositoryId();
        }
        if ((importedFileEntry = this._fetchFileEntry(fileEntryId = MapUtil.getLong((Map)(fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class)), (long)fileShortcut.getToFileEntryId(), (long)fileShortcut.getToFileEntryId()))) == null) {
            return;
        }
        long userId = portletDataContext.getUserId(fileShortcut.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)fileShortcut, DLFileShortcut.class);
        FileShortcut importedFileShortcut = null;
        if (portletDataContext.isDataStrategyMirror()) {
            FileShortcut existingFileShortcut = this._fetchFileShortcutByExternalReferenceCode(fileShortcut.getExternalReferenceCode(), portletDataContext.getScopeGroupId());
            if (existingFileShortcut == null) {
                existingFileShortcut = this.fetchStagedModelByUuidAndGroupId(fileShortcut.getUuid(), portletDataContext.getScopeGroupId());
            }
            if (existingFileShortcut == null) {
                serviceContext.setUuid(fileShortcut.getUuid());
                importedFileShortcut = this._dlAppLocalService.addFileShortcut(fileShortcut.getExternalReferenceCode(), userId, groupId, folderId, importedFileEntry.getFileEntryId(), serviceContext);
            } else {
                importedFileShortcut = this._dlAppLocalService.updateFileShortcut(userId, existingFileShortcut.getFileShortcutId(), folderId, importedFileEntry.getFileEntryId(), serviceContext);
            }
        } else {
            importedFileShortcut = this._dlAppLocalService.addFileShortcut(null, userId, groupId, folderId, importedFileEntry.getFileEntryId(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)fileShortcut, (ClassedModel)importedFileShortcut, DLFileShortcut.class);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, FileShortcut fileShortcut) throws Exception {
        FileShortcut existingFileShortcut = this.fetchStagedModelByUuidAndGroupId(fileShortcut.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFileShortcut == null || !(existingFileShortcut.getModel() instanceof DLFileShortcut)) {
            return;
        }
        DLFileShortcut dlFileShortcut = (DLFileShortcut)existingFileShortcut.getModel();
        if (!dlFileShortcut.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFileShortcut.class.getName());
        if (trashHandler.isRestorable(existingFileShortcut.getFileShortcutId())) {
            trashHandler.restoreTrashEntry(portletDataContext.getUserId(fileShortcut.getUserUuid()), existingFileShortcut.getFileShortcutId());
        }
    }

    private FileEntry _fetchFileEntry(long fileEntryId) {
        try {
            return this._dlAppLocalService.getFileEntry(fileEntryId);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get file entry " + fileEntryId), (Throwable)portalException);
            }
            return null;
        }
    }

    private FileShortcut _fetchFileShortcutByExternalReferenceCode(String externalReferenceCode, long groupId) {
        DLFileShortcut dlFileShortcut = this._dlFileShortcutLocalService.fetchDLFileShortcutByExternalReferenceCode(externalReferenceCode, groupId);
        if (dlFileShortcut == null) {
            if (_log.isDebugEnabled()) {
                StringBundler sb = new StringBundler(6);
                sb.append("No DLFileShortcut exists with the key {");
                sb.append("externalReferenceCode=");
                sb.append(externalReferenceCode);
                sb.append(", groupId=");
                sb.append(groupId);
                sb.append("}");
                _log.debug((Object)sb.toString());
            }
            return null;
        }
        return new LiferayFileShortcut(dlFileShortcut);
    }
}

