/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.change.tracking.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConstraintResolver.class})
public class RepositoryConstraintResolver
implements ConstraintResolver<Repository> {
    @Reference
    private RepositoryLocalService _repositoryLocalService;
    private boolean _resolved;

    public String getConflictDescriptionKey() {
        return "duplicate-repository";
    }

    public Class<Repository> getModelClass() {
        return Repository.class;
    }

    public String getResolutionDescriptionKey() {
        if (this._resolved) {
            return "duplicate-repository-was-removed";
        }
        return "duplicate-repository-conflict-was-not-automatically-resolved";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((Locale)locale, RepositoryConstraintResolver.class);
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"groupId", "name", "portletId"};
    }

    public void resolveConflict(ConstraintResolverContext<Repository> constraintResolverContext) throws PortalException {
        Repository sourceRepository = (Repository)constraintResolverContext.getSourceCTModel();
        Repository targetRepository = (Repository)constraintResolverContext.getTargetCTModel();
        if (StringUtil.equals((String)sourceRepository.getName(), (String)TempFileEntryUtil.class.getName()) && StringUtil.equals((String)targetRepository.getName(), (String)TempFileEntryUtil.class.getName())) {
            this._repositoryLocalService.deleteRepository(sourceRepository);
            this._resolved = true;
        } else {
            this._resolved = false;
        }
    }
}

