/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.change.tracking.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.store.DLStoreRequest;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.comparator.DLFileVersionVersionComparator;
import com.liferay.document.library.kernel.util.comparator.VersionNumberComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.language.LanguageResources;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.UUID;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConstraintResolver.class})
public class DLFileVersionConstraintResolver
implements ConstraintResolver<DLFileVersion> {
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;

    public String getConflictDescriptionKey() {
        return "duplicate-document-version";
    }

    public Class<DLFileVersion> getModelClass() {
        return DLFileVersion.class;
    }

    public String getResolutionDescriptionKey() {
        return "the-document-version-was-updated-to-latest";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return LanguageResources.getResourceBundle((Locale)locale);
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"fileEntryId", "version"};
    }

    public void resolveConflict(ConstraintResolverContext<DLFileVersion> constraintResolverContext) throws PortalException {
        DLFileVersion dlFileVersion = (DLFileVersion)constraintResolverContext.getSourceCTModel();
        List latestVersionParts = (List)constraintResolverContext.getInTarget(() -> {
            DLFileVersion latestFileVersion = this._dlFileVersionLocalService.getLatestFileVersion(dlFileVersion.getFileEntryId(), false);
            return StringUtil.split((String)latestFileVersion.getVersion(), (char)'.');
        });
        if (latestVersionParts.isEmpty()) {
            return;
        }
        List fileVersions = this._dlFileVersionLocalService.getFileVersions(dlFileVersion.getFileEntryId(), -1);
        fileVersions.sort(DLFileVersionVersionComparator.getInstance((boolean)true));
        String newFileVersion = null;
        DLFileVersion previousFileVersion = null;
        TreeMap<String, String> versionMap = new TreeMap<String, String>((Comparator<String>)new VersionNumberComparator());
        for (DLFileVersion fileVersion : fileVersions) {
            if (!constraintResolverContext.isSourceCTModel((CTModel)fileVersion)) {
                previousFileVersion = fileVersion;
                continue;
            }
            if (previousFileVersion == null) {
                return;
            }
            List ctVersionParts = StringUtil.split((String)fileVersion.getVersion(), (char)'.');
            List previousVersionParts = StringUtil.split((String)previousFileVersion.getVersion(), (char)'.');
            if (latestVersionParts.size() != ctVersionParts.size() || latestVersionParts.size() != previousVersionParts.size()) {
                return;
            }
            StringBundler sb = new StringBundler(2 * latestVersionParts.size());
            for (int i = 0; i < latestVersionParts.size(); ++i) {
                int versionIncrease = Math.abs(GetterUtil.getInteger((String)((String)ctVersionParts.get(i))) - GetterUtil.getInteger((String)((String)previousVersionParts.get(i))));
                if (versionIncrease > 0) {
                    int latestVersionPart = GetterUtil.getInteger((String)((String)latestVersionParts.get(i)));
                    sb.append(latestVersionPart + versionIncrease);
                    for (int j = i + 1; j < ctVersionParts.size(); ++j) {
                        sb.append(".0");
                    }
                    break;
                }
                sb.append((String)latestVersionParts.get(i));
                sb.append(".");
            }
            newFileVersion = sb.toString();
            String oldStoreFileName = fileVersion.getStoreFileName();
            fileVersion.setVersion(newFileVersion);
            fileVersion.setStoreUUID(String.valueOf(UUID.randomUUID()));
            fileVersion = this._dlFileVersionLocalService.updateDLFileVersion(fileVersion);
            versionMap.put(oldStoreFileName, fileVersion.getStoreFileName());
            previousFileVersion = fileVersion;
        }
        if (newFileVersion == null) {
            return;
        }
        DLFileEntry dlFileEntry = dlFileVersion.getFileEntry();
        dlFileEntry.setVersion(newFileVersion);
        dlFileEntry = this._dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
        for (Map.Entry entry : versionMap.entrySet()) {
            String oldStoreFileName = (String)entry.getKey();
            String newStoreFileName = (String)entry.getValue();
            try (InputStream inputStream = DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)oldStoreFileName);){
                DLStoreUtil.addFile((DLStoreRequest)DLStoreRequest.builder((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getRepositoryId(), (String)dlFileEntry.getName()).versionLabel(newStoreFileName).build(), (InputStream)inputStream);
            }
            catch (IOException ioException) {
                throw new UncheckedIOException(ioException);
            }
            DLStoreUtil.deleteFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getRepositoryId(), (String)dlFileEntry.getName(), (String)oldStoreFileName);
        }
    }
}

