/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection.action;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"bulk.selection.action.key=edit.categories"}, service={BulkSelectionAction.class})
public class EditCategoriesBulkSelectionAction
implements BulkSelectionAction<AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(EditCategoriesBulkSelectionAction.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;

    public void execute(User user, BulkSelection<AssetEntry> bulkSelection, Map<String, Serializable> inputMap) throws Exception {
        Set<Long> toAddCategoryIdsSet = this._toLongSet(inputMap, "toAddCategoryIds");
        Set<Long> toRemoveCategoryIdsSet = this._toLongSet(inputMap, "toRemoveCategoryIds");
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        bulkSelection.forEach(assetEntry -> {
            block5: {
                try {
                    if (!ModelResourcePermissionUtil.contains((PermissionChecker)permissionChecker, (long)assetEntry.getGroupId(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), (String)"UPDATE").booleanValue()) {
                        return;
                    }
                    long[] newCategoryIds = new long[]{};
                    if (SetUtil.isNotEmpty((Set)toAddCategoryIdsSet)) {
                        newCategoryIds = ArrayUtil.toLongArray((Collection)toAddCategoryIdsSet);
                    }
                    if (MapUtil.getBoolean((Map)inputMap, (String)"append")) {
                        Set currentCategoryIdsSet = SetUtil.fromArray((long[])assetEntry.getCategoryIds());
                        currentCategoryIdsSet.removeAll(toRemoveCategoryIdsSet);
                        currentCategoryIdsSet.addAll(toAddCategoryIdsSet);
                        newCategoryIds = ArrayUtil.toLongArray((Collection)currentCategoryIdsSet);
                    }
                    this._assetEntryLocalService.updateEntry(assetEntry.getUserId(), assetEntry.getGroupId(), assetEntry.getClassName(), assetEntry.getClassPK(), newCategoryIds, assetEntry.getTagNames());
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Throwable)portalException);
                }
            }
        });
    }

    private Set<Long> _toLongSet(Map<String, Serializable> map, String key) {
        try {
            Serializable values = map.get(key);
            if (values instanceof Long[]) {
                return SetUtil.fromArray((Object[])((Long[])values));
            }
            HashSet<Long> set = new HashSet<Long>();
            for (Integer value : (Integer[])values) {
                set.add(value.longValue());
            }
            return set;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return SetUtil.fromArray((Object[])new Long[0]);
        }
    }
}

