/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.versioning;

import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.versioning.VersioningPolicy;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManagerUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={VersioningPolicy.class})
public class MetadataVersioningPolicy
implements VersioningPolicy {
    private static final Log _log = LogFactoryUtil.getLog(MetadataVersioningPolicy.class);
    @Reference
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;

    public Optional<DLVersionNumberIncrease> computeDLVersionNumberIncrease(DLFileVersion previousDLFileVersion, DLFileVersion nextDLFileVersion) {
        if (!Objects.equals(previousDLFileVersion.getTitle(), nextDLFileVersion.getTitle())) {
            return Optional.of(DLVersionNumberIncrease.MINOR);
        }
        if (!Objects.equals(previousDLFileVersion.getDescription(), nextDLFileVersion.getDescription())) {
            return Optional.of(DLVersionNumberIncrease.MINOR);
        }
        if (previousDLFileVersion.getFileEntryTypeId() != nextDLFileVersion.getFileEntryTypeId()) {
            return Optional.of(DLVersionNumberIncrease.MINOR);
        }
        if (this._isDLFileEntryTypeUpdated(previousDLFileVersion, nextDLFileVersion)) {
            return Optional.of(DLVersionNumberIncrease.MINOR);
        }
        if (this._isExpandoUpdated(previousDLFileVersion, nextDLFileVersion)) {
            return Optional.of(DLVersionNumberIncrease.MINOR);
        }
        return Optional.empty();
    }

    private boolean _isDLFileEntryTypeUpdated(DLFileVersion previousDLFileVersion, DLFileVersion nextDLFileVersion) {
        try {
            DLFileEntryType dlFileEntryType = previousDLFileVersion.getDLFileEntryType();
            for (DDMStructure ddmStructure : dlFileEntryType.getDDMStructures()) {
                DDMFormValues nextDDMFormValues;
                DLFileEntryMetadata previousFileEntryMetadata = this._dlFileEntryMetadataLocalService.fetchFileEntryMetadata(ddmStructure.getStructureId(), previousDLFileVersion.getFileVersionId());
                if (previousFileEntryMetadata == null) {
                    return true;
                }
                DLFileEntryMetadata nextFileEntryMetadata = this._dlFileEntryMetadataLocalService.getFileEntryMetadata(ddmStructure.getStructureId(), nextDLFileVersion.getFileVersionId());
                DDMFormValues previousDDMFormValues = StorageEngineManagerUtil.getDDMFormValues((long)previousFileEntryMetadata.getDDMStorageId());
                if (previousDDMFormValues.equals((Object)(nextDDMFormValues = StorageEngineManagerUtil.getDDMFormValues((long)nextFileEntryMetadata.getDDMStorageId())))) continue;
                return true;
            }
            return false;
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)portalException, (Throwable)portalException);
            }
            return false;
        }
    }

    private boolean _isExpandoUpdated(DLFileVersion previousDLFileVersion, DLFileVersion nextDLFileVersion) {
        Map nextAttributes;
        ExpandoBridge previousExpandoBridge = previousDLFileVersion.getExpandoBridge();
        ExpandoBridge nextExpandoBridge = nextDLFileVersion.getExpandoBridge();
        Map previousAttributes = previousExpandoBridge.getAttributes();
        return !previousAttributes.equals(nextAttributes = nextExpandoBridge.getAttributes());
    }
}

