/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.lock;

import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLFileEntryService;
import com.liferay.portal.kernel.lock.BaseLockListener;
import com.liferay.portal.kernel.lock.LockListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsValues;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LockListener.class})
public class DLFileEntryLockListener
extends BaseLockListener {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryLockListener.class);
    @Reference
    private DLFileEntryService _dlFileEntryService;

    public String getClassName() {
        return DLFileEntryConstants.getClassName();
    }

    public void onAfterExpire(String key) {
        long fileEntryId = GetterUtil.getLong((String)key);
        try {
            if (PropsValues.DL_FILE_ENTRY_LOCK_POLICY == 1) {
                this._dlFileEntryService.checkInFileEntry(fileEntryId, DLVersionNumberIncrease.fromMajorVersion((boolean)true), "Automatic timeout checkin", new ServiceContext());
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Lock expired and checked in " + fileEntryId));
                }
            } else {
                this._dlFileEntryService.cancelCheckOut(fileEntryId);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Lock expired and canceled check out of " + fileEntryId));
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to execute onAfterExpire for " + key), (Throwable)exception);
        }
    }
}

