/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.exportimport.data.handler;

import com.liferay.changeset.service.ChangesetCollectionLocalService;
import com.liferay.changeset.service.ChangesetEntryLocalService;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.portlet.data.handler.util.ExportImportGroupedModelUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.repository.portletrepository.PortletRepository;
import com.liferay.portal.util.RepositoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class FolderStagedModelDataHandler
extends BaseStagedModelDataHandler<Folder> {
    public static final String[] CLASS_NAMES = new String[]{DLFolder.class.getName(), Folder.class.getName(), LiferayFolder.class.getName()};
    @Reference
    private ChangesetCollectionLocalService _changesetCollectionLocalService;
    @Reference
    private ChangesetEntryLocalService _changesetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RepositoryLocalService _repositoryLocalService;

    public void deleteStagedModel(Folder folder) throws PortalException {
        this._dlAppLocalService.deleteFolder(folder.getFolderId());
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Folder folder = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (folder != null) {
            this.deleteStagedModel(folder);
        }
    }

    public Folder fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        DLFolder dlFolder = this._dlFolderLocalService.fetchFolder(uuid, groupId);
        if (dlFolder != null) {
            return new LiferayFolder(dlFolder);
        }
        return null;
    }

    public List<Folder> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        List dlFolders = this._dlFolderLocalService.getDLFoldersByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (DLFolder dlFolder : dlFolders) {
            folders.add((Folder)new LiferayFolder(dlFolder));
        }
        return folders;
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Folder folder) {
        return folder.getName();
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, Folder stagedModel) throws PortletDataException {
        try {
            this.doRestoreStagedModel(portletDataContext, stagedModel);
        }
        catch (PortletDataException portletDataException) {
            throw portletDataException;
        }
        catch (Exception exception) {
            throw new PortletDataException((Throwable)exception);
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Folder folder) throws Exception {
        Element folderElement = portletDataContext.getExportDataElement((ClassedModel)folder);
        String folderPath = ExportImportPathUtil.getModelPath((StagedModel)folder);
        if (!folder.isDefaultRepository()) {
            Repository repository = this._repositoryLocalService.getRepository(folder.getRepositoryId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, (StagedModel)repository, (String)"strong");
            boolean rootFolder = false;
            if (folder.getFolderId() == repository.getDlFolderId()) {
                rootFolder = true;
            }
            folderElement.addAttribute("rootFolder", String.valueOf(rootFolder));
            long portletRepositoryClassNameId = this._portal.getClassNameId(PortletRepository.class.getName());
            if (repository.getClassNameId() != portletRepositoryClassNameId) {
                return;
            }
        }
        if (folder.getParentFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, (StagedModel)folder.getParentFolder(), (String)"parent");
        }
        this.exportFolderFileEntryTypes(portletDataContext, folderElement, folder);
        portletDataContext.addClassedModel(folderElement, folderPath, (ClassedModel)folder, DLFolder.class);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long folderId) {
        Folder existingFolder = (Folder)this.fetchMissingReference(uuid, groupId);
        if (existingFolder == null) {
            return;
        }
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        folderIds.put(folderId, existingFolder.getFolderId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Folder folder) throws Exception {
        Map folderIdsAndRepositoryEntryIds = portletDataContext.getNewPrimaryKeysMap(Folder.class + ".folderIdsAndRepositoryEntryIds");
        if (RepositoryUtil.isExternalRepository((long)folder.getRepositoryId())) {
            Map repositoryEntryIds = portletDataContext.getNewPrimaryKeysMap(RepositoryEntry.class);
            folderIdsAndRepositoryEntryIds.put(folder.getFolderId(), repositoryEntryIds.get(folder.getFolderId()));
            return;
        }
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        Map repositoryIds = portletDataContext.getNewPrimaryKeysMap(Repository.class);
        long repositoryId = MapUtil.getLong((Map)repositoryIds, (long)folder.getRepositoryId(), (long)portletDataContext.getScopeGroupId());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        long parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)folder, DLFolder.class);
        serviceContext.setUserId(userId);
        Element folderElement = portletDataContext.getImportDataElement((StagedModel)folder);
        Folder importedFolder = null;
        boolean rootFolder = GetterUtil.getBoolean((String)folderElement.attributeValue("rootFolder"));
        if (rootFolder) {
            Repository repository = this._repositoryLocalService.getRepository(repositoryId);
            importedFolder = this._dlAppLocalService.getFolder(repository.getDlFolderId());
        } else {
            Folder existingFolder = this.fetchStagedModelByUuidAndGroupId(folder.getUuid(), portletDataContext.getScopeGroupId());
            if (existingFolder == null || !portletDataContext.isDataStrategyMirror()) {
                String uuid = null;
                if (portletDataContext.isDataStrategyMirror()) {
                    uuid = folder.getUuid();
                    serviceContext.setUuid(uuid);
                }
                String name = this._dlFolderLocalService.getUniqueFolderName(uuid, portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                importedFolder = this._dlAppLocalService.addFolder(userId, repositoryId, parentFolderId, name, folder.getDescription(), serviceContext);
            } else {
                String name = this._dlFolderLocalService.getUniqueFolderName(folder.getUuid(), portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                importedFolder = this._dlAppLocalService.updateFolder(existingFolder.getFolderId(), parentFolderId, name, folder.getDescription(), serviceContext);
            }
        }
        this.importFolderFileEntryTypes(portletDataContext, folderElement, folder, importedFolder, serviceContext);
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder, DLFolder.class);
        folderIds.put(folder.getFolderId(), importedFolder.getFolderId());
        folderIdsAndRepositoryEntryIds.put(folder.getFolderId(), importedFolder.getFolderId());
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, Folder folder) throws Exception {
        Folder existingFolder = this.fetchStagedModelByUuidAndGroupId(folder.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFolder == null || !existingFolder.isRepositoryCapabilityProvided(TrashCapability.class)) {
            return;
        }
        TrashCapability trashCapability = (TrashCapability)existingFolder.getRepositoryCapability(TrashCapability.class);
        if (!trashCapability.isInTrash(existingFolder)) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFolder.class.getName());
        if (trashHandler.isRestorable(existingFolder.getFolderId())) {
            trashHandler.restoreTrashEntry(portletDataContext.getUserId(folder.getUserUuid()), existingFolder.getFolderId());
        }
    }

    protected void exportFolderFileEntryTypes(PortletDataContext portletDataContext, Element folderElement, Folder folder) throws Exception {
        if (!folder.isDefaultRepository()) {
            return;
        }
        List dlFileEntryTypes = this._dlFileEntryTypeLocalService.getFolderFileEntryTypes(new long[]{portletDataContext.getCompanyGroupId(), portletDataContext.getScopeGroupId()}, folder.getFolderId(), false);
        long defaultFileEntryTypeId = this._dlFileEntryTypeLocalService.getDefaultFileEntryTypeId(folder.getFolderId());
        String defaultFileEntryTypeUuid = "";
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            if (dlFileEntryType.getFileEntryTypeId() == 0L) {
                folderElement.addAttribute("basic-document", "true");
                continue;
            }
            if (defaultFileEntryTypeId == dlFileEntryType.getFileEntryTypeId()) {
                defaultFileEntryTypeUuid = dlFileEntryType.getUuid();
            }
            if (!dlFileEntryType.isExportable()) continue;
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, (StagedModel)dlFileEntryType, (String)"strong");
        }
        folderElement.addAttribute("defaultFileEntryTypeUuid", defaultFileEntryTypeUuid);
    }

    protected void importFolderFileEntryTypes(PortletDataContext portletDataContext, Element folderElement, Folder folder, Folder importedFolder, ServiceContext serviceContext) throws PortalException {
        if (!folder.isDefaultRepository()) {
            return;
        }
        ArrayList<Long> currentFolderFileEntryTypeIds = new ArrayList<Long>();
        String defaultFileEntryTypeUuid = GetterUtil.getString((String)folderElement.attributeValue("defaultFileEntryTypeUuid"));
        long defaultFileEntryTypeId = 0L;
        List referenceElements = portletDataContext.getReferenceElements((StagedModel)folder, DLFileEntryType.class);
        for (Element referenceElement : referenceElements) {
            long referenceDLFileEntryTypeId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
            Map dlFileEntryTypeIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntryType.class);
            long dlFileEntryTypeId = MapUtil.getLong((Map)dlFileEntryTypeIds, (long)referenceDLFileEntryTypeId, (long)referenceDLFileEntryTypeId);
            DLFileEntryType existingDLFileEntryType = this._dlFileEntryTypeLocalService.fetchDLFileEntryType(dlFileEntryTypeId);
            if (existingDLFileEntryType == null) continue;
            currentFolderFileEntryTypeIds.add(existingDLFileEntryType.getFileEntryTypeId());
            if (!defaultFileEntryTypeUuid.equals(referenceElement.attributeValue("uuid"))) continue;
            defaultFileEntryTypeId = existingDLFileEntryType.getFileEntryTypeId();
        }
        if (GetterUtil.getBoolean((String)folderElement.attributeValue("basic-document"))) {
            currentFolderFileEntryTypeIds.add(0L);
        }
        if (!currentFolderFileEntryTypeIds.isEmpty()) {
            DLFolder dlFolder = this._dlFolderLocalService.getDLFolder(importedFolder.getFolderId());
            dlFolder.setDefaultFileEntryTypeId(defaultFileEntryTypeId);
            dlFolder.setRestrictionType(1);
            dlFolder = this._dlFolderLocalService.updateDLFolder(dlFolder);
            this._dlFileEntryTypeLocalService.updateFolderFileEntryTypes(dlFolder, currentFolderFileEntryTypeIds, defaultFileEntryTypeId, serviceContext);
        }
    }

    protected void validateExport(PortletDataContext portletDataContext, Folder folder) throws PortletDataException {
        LiferayFolder liferayFolder;
        DLFolder dlFolder;
        if (folder.getGroupId() != portletDataContext.getGroupId() && folder.getGroupId() != portletDataContext.getScopeGroupId() && !ExportImportGroupedModelUtil.isReferenceInLayoutGroupWithinExportScope((PortletDataContext)portletDataContext, (GroupedModel)folder)) {
            PortletDataException portletDataException = new PortletDataException(4);
            portletDataException.setStagedModelDisplayName(folder.getName());
            portletDataException.setStagedModelClassName(folder.getModelClassName());
            portletDataException.setStagedModelClassPK(GetterUtil.getString((Object)folder.getFolderId()));
            throw portletDataException;
        }
        if (folder instanceof LiferayFolder && ((dlFolder = (DLFolder)(liferayFolder = (LiferayFolder)folder).getModel()).isInTrash() || dlFolder.isInTrashContainer())) {
            PortletDataException portletDataException = new PortletDataException(8);
            portletDataException.setStagedModelDisplayName(folder.getName());
            portletDataException.setStagedModelClassName(folder.getModelClassName());
            portletDataException.setStagedModelClassPK(GetterUtil.getString((Object)folder.getFolderId()));
            throw portletDataException;
        }
    }
}

