/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.trash;

import com.liferay.document.library.internal.trash.DLBaseTrashHandler;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.service.DLTrashLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.capabilities.UnsupportedCapabilityException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={TrashHandler.class})
public class DLFileEntryTrashHandler
extends DLBaseTrashHandler {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryTrashHandler.class);
    private DLAppLocalService _dlAppLocalService;
    private DLFileEntryLocalService _dlFileEntryLocalService;
    private DLFileVersionLocalService _dlFileVersionLocalService;
    private DLFolderLocalService _dlFolderLocalService;
    private DLTrashLocalService _dlTrashLocalService;
    @Reference
    private DLValidator _dlValidator;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.repository.model.FileEntry)")
    private ModelResourcePermission<FileEntry> _fileEntryModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.repository.model.Folder)")
    private ModelResourcePermission<Folder> _folderModelResourcePermission;

    public void checkRestorableEntry(long classPK, long containerModelId, String newName) throws PortalException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        this.checkRestorableEntry(classPK, 0L, containerModelId, dlFileEntry.getFileName(), dlFileEntry.getTitle(), newName);
    }

    public void checkRestorableEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException {
        this.checkRestorableEntry(trashEntry.getClassPK(), trashEntry.getEntryId(), containerModelId, trashEntry.getTypeSettingsProperty("fileName"), trashEntry.getTypeSettingsProperty("title"), newName);
    }

    public void deleteTrashEntry(long classPK) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        TrashCapability trashCapability = (TrashCapability)documentRepository.getCapability(TrashCapability.class);
        trashCapability.deleteFileEntry(documentRepository.getFileEntry(classPK));
    }

    public String getClassName() {
        return DLFileEntry.class.getName();
    }

    public Filter getExcludeFilter(SearchContext searchContext) {
        BooleanFilter excludeBooleanFilter = new BooleanFilter();
        excludeBooleanFilter.addRequiredTerm("entryClassName", DLFileEntryConstants.getClassName());
        excludeBooleanFilter.addRequiredTerm("hidden", true);
        return excludeBooleanFilter;
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        long parentFolderId = dlFileEntry.getFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException {
        DLFileEntry dlFileEntry = (DLFileEntry)trashedModel;
        return this.getContainerModel(dlFileEntry.getFolderId());
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        return DLUtil.getDLFileEntryControlPanelLink((PortletRequest)portletRequest, (long)dlFileEntry.getFileEntryId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        return DLUtil.getDLFolderControlPanelLink((PortletRequest)portletRequest, (long)dlFileEntry.getFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        DLFolder dlFolder = dlFileEntry.getFolder();
        return DLUtil.getAbsolutePath((PortletRequest)portletRequest, (long)dlFolder.getFolderId());
    }

    public String getSystemEventClassName() {
        return DLFileEntryConstants.getClassName();
    }

    public TrashedModel getTrashedModel(long classPK) {
        try {
            return this.getDLFileEntry(classPK);
        }
        catch (PortalException | UnsupportedCapabilityException e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, e);
            }
            return null;
        }
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return ModelResourcePermissionHelper.contains(this._folderModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)classPK, (String)"ADD_DOCUMENT");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isMovable(long classPK) throws PortalException {
        DLFolder parentFolder;
        DLFileEntry dlFileEntry = this.fetchDLFileEntry(classPK);
        return dlFileEntry.getFolderId() > 0L && ((parentFolder = this._dlFolderLocalService.fetchFolder(dlFileEntry.getFolderId())) == null || parentFolder.isInTrash());
    }

    public boolean isRestorable(long classPK) throws PortalException {
        DLFileEntry dlFileEntry = this.fetchDLFileEntry(classPK);
        if (dlFileEntry == null || dlFileEntry.getFolderId() > 0L && this._dlFolderLocalService.fetchFolder(dlFileEntry.getFolderId()) == null) {
            return false;
        }
        if (!this.hasTrashPermission(PermissionThreadLocal.getPermissionChecker(), dlFileEntry.getGroupId(), classPK, "RESTORE")) {
            return false;
        }
        return !dlFileEntry.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this._dlAppLocalService.moveFileEntry(userId, classPK, containerModelId, serviceContext);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        this._dlTrashLocalService.moveFileEntryFromTrash(userId, documentRepository.getRepositoryId(), classPK, containerModelId, serviceContext);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        if (dlFileEntry.getClassNameId() > 0L && dlFileEntry.getClassPK() > 0L) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)dlFileEntry.getClassName());
            trashHandler.restoreRelatedTrashEntry(this.getClassName(), classPK);
            return;
        }
        this._dlTrashLocalService.restoreFileEntryFromTrash(userId, dlFileEntry.getRepositoryId(), classPK);
    }

    public void updateTitle(long classPK, String name) throws PortalException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        String fileName = DLUtil.getSanitizedFileName((String)name, (String)dlFileEntry.getExtension());
        dlFileEntry.setFileName(fileName);
        dlFileEntry.setTitle(name);
        this._dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        dlFileVersion.setFileName(fileName);
        dlFileVersion.setTitle(name);
        this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
    }

    protected void checkRestorableEntry(long classPK, long entryId, long containerModelId, String originalFileName, String originalTitle, String newName) throws PortalException {
        DLFolder duplicateDLFolder;
        if (Validator.isNotNull((String)newName) && !this._dlValidator.isValidName(newName)) {
            RestoreEntryException ree = new RestoreEntryException(3);
            ree.setErrorMessage("please-enter-a-valid-name");
            ree.setTrashEntryId(entryId);
            throw ree;
        }
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        if (containerModelId == -1L) {
            containerModelId = dlFileEntry.getFolderId();
        }
        if (Validator.isNotNull((String)newName)) {
            originalFileName = DLUtil.getSanitizedFileName((String)newName, (String)dlFileEntry.getExtension());
            originalTitle = newName;
        }
        if ((duplicateDLFolder = this._dlFolderLocalService.fetchFolder(dlFileEntry.getGroupId(), containerModelId, originalTitle)) != null) {
            RestoreEntryException ree = new RestoreEntryException(1);
            ree.setDuplicateEntryId(duplicateDLFolder.getFolderId());
            ree.setOldName(duplicateDLFolder.getName());
            ree.setOverridable(false);
            ree.setTrashEntryId(entryId);
            throw ree;
        }
        DLFileEntry duplicateDLFileEntry = this._dlFileEntryLocalService.fetchFileEntry(dlFileEntry.getGroupId(), containerModelId, originalTitle);
        if (duplicateDLFileEntry == null) {
            duplicateDLFileEntry = this._dlFileEntryLocalService.fetchFileEntryByFileName(dlFileEntry.getGroupId(), containerModelId, originalFileName);
        }
        if (duplicateDLFileEntry != null) {
            RestoreEntryException ree = new RestoreEntryException(1);
            ree.setDuplicateEntryId(duplicateDLFileEntry.getFileEntryId());
            ree.setOldName(duplicateDLFileEntry.getTitle());
            ree.setTrashEntryId(entryId);
            throw ree;
        }
    }

    protected DLFileEntry fetchDLFileEntry(long classPK) throws PortalException {
        Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)classPK);
        if (!repository.isCapabilityProvided(TrashCapability.class)) {
            return null;
        }
        FileEntry fileEntry = repository.getFileEntry(classPK);
        return (DLFileEntry)fileEntry.getModel();
    }

    protected DLFileEntry getDLFileEntry(long classPK) throws PortalException {
        Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)classPK);
        if (!repository.isCapabilityProvided(TrashCapability.class)) {
            throw new UnsupportedCapabilityException(TrashCapability.class, "Repository " + repository.getRepositoryId());
        }
        FileEntry fileEntry = repository.getFileEntry(classPK);
        return (DLFileEntry)fileEntry.getModel();
    }

    @Override
    protected DocumentRepository getDocumentRepository(long classPK) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getFileEntryLocalRepository((long)classPK);
        if (!localRepository.isCapabilityProvided(TrashCapability.class)) {
            throw new UnsupportedCapabilityException(TrashCapability.class, "Repository " + localRepository.getRepositoryId());
        }
        return localRepository;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        if (dlFileEntry.isInHiddenFolder() && actionId.equals("VIEW")) {
            return false;
        }
        return this._fileEntryModelResourcePermission.contains(permissionChecker, classPK, actionId);
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileVersionLocalService(DLFileVersionLocalService dlFileVersionLocalService) {
        this._dlFileVersionLocalService = dlFileVersionLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this._dlFolderLocalService = dlFolderLocalService;
    }

    @Reference(unbind="-")
    protected void setDLTrashLocalService(DLTrashLocalService dlTrashLocalService) {
        this._dlTrashLocalService = dlTrashLocalService;
    }
}

