/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external.model;

import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.repository.external.ExtRepositoryAdapter;
import com.liferay.document.library.repository.external.ExtRepositoryFileEntry;
import com.liferay.document.library.repository.external.model.ExtRepositoryFileVersionAdapter;
import com.liferay.document.library.repository.external.model.ExtRepositoryObjectAdapter;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

public class ExtRepositoryFileEntryAdapter
extends ExtRepositoryObjectAdapter<FileEntry>
implements FileEntry {
    private static final Log _log = LogFactoryUtil.getLog(ExtRepositoryFileEntryAdapter.class);
    private final ExtRepositoryFileEntry _extRepositoryFileEntry;

    public ExtRepositoryFileEntryAdapter(ExtRepositoryAdapter extRepositoryAdapter, long extRepositoryObjectId, String uuid, ExtRepositoryFileEntry extRepositoryFileEntry) {
        super(extRepositoryAdapter, extRepositoryObjectId, uuid, extRepositoryFileEntry);
        this._extRepositoryFileEntry = extRepositoryFileEntry;
    }

    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        repositoryModelOperation.execute((FileEntry)this);
    }

    public InputStream getContentStream() throws PortalException {
        ExtRepositoryAdapter extRepositoryAdapter = this.getRepository();
        return extRepositoryAdapter.getContentStream(this);
    }

    public InputStream getContentStream(String version) throws PortalException {
        ExtRepositoryAdapter extRepositoryAdapter = this.getRepository();
        FileVersion fileVersion = this.getFileVersion(version);
        return extRepositoryAdapter.getContentStream((ExtRepositoryFileVersionAdapter)fileVersion);
    }

    @Override
    public ExtRepositoryFileEntry getExtRepositoryModel() {
        return this._extRepositoryFileEntry;
    }

    public long getFileEntryId() {
        return this.getPrimaryKey();
    }

    public String getFileName() {
        return DLUtil.getSanitizedFileName((String)this.getTitle(), (String)this.getExtension());
    }

    public List<FileShortcut> getFileShortcuts() {
        return Collections.emptyList();
    }

    public FileVersion getFileVersion() {
        try {
            List<ExtRepositoryFileVersionAdapter> extRepositoryFileVersionAdapters = this._getExtRepositoryFileVersionAdapters();
            return extRepositoryFileVersionAdapters.get(0);
        }
        catch (PortalException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    public FileVersion getFileVersion(String version) throws PortalException {
        List<ExtRepositoryFileVersionAdapter> extRepositoryFileVersionAdapters = this._getExtRepositoryFileVersionAdapters();
        for (ExtRepositoryFileVersionAdapter extRepositoryFileVersionAdapter : extRepositoryFileVersionAdapters) {
            String curVersion = extRepositoryFileVersionAdapter.getVersion();
            if (!curVersion.equals(version)) continue;
            return extRepositoryFileVersionAdapter;
        }
        throw new NoSuchFileVersionException("No file version with {fileEntryId=" + this.getFileEntryId() + ", version: " + version + "}");
    }

    public List<FileVersion> getFileVersions(int status) {
        if (status == -1 || status == 0) {
            try {
                return this._getExtRepositoryFileVersionAdapters();
            }
            catch (PortalException pe) {
                throw new SystemException((Throwable)pe);
            }
        }
        return Collections.emptyList();
    }

    public int getFileVersionsCount(int status) {
        List<FileVersion> fileVersions = this.getFileVersions(status);
        return fileVersions.size();
    }

    public Folder getFolder() {
        Folder parentFolder = null;
        try {
            parentFolder = this.getParentFolder();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return parentFolder;
    }

    public long getFolderId() {
        Folder folder = this.getFolder();
        return folder.getFolderId();
    }

    public String getIcon() {
        return DLUtil.getFileIcon((String)this.getExtension());
    }

    public String getIconCssClass() {
        return DLUtil.getFileIconCssClass((String)this.getExtension());
    }

    public FileVersion getLatestFileVersion() throws PortalException {
        return this.getFileVersion();
    }

    public FileVersion getLatestFileVersion(boolean trusted) throws PortalException {
        return this.getFileVersion();
    }

    public Lock getLock() {
        if (!this.isCheckedOut()) {
            return null;
        }
        String checkedOutBy = this._extRepositoryFileEntry.getCheckedOutBy();
        User user = this.getUser(checkedOutBy);
        long userId = 0L;
        String userName = null;
        if (user != null) {
            userId = user.getUserId();
            userName = user.getFullName();
        }
        return LockManagerUtil.createLock((long)0L, (long)this.getCompanyId(), (long)userId, (String)userName);
    }

    public String getMimeType() {
        String mimeType = this._extRepositoryFileEntry.getMimeType();
        if (Validator.isNull((String)mimeType)) {
            mimeType = MimeTypesUtil.getContentType((String)this.getTitle());
        }
        return mimeType;
    }

    public String getMimeType(String version) {
        String mimeType;
        FileVersion fileVersion;
        block5: {
            fileVersion = null;
            try {
                fileVersion = this.getFileVersion(version);
            }
            catch (PortalException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to obtain version " + version + " for external " + "repository file entry " + this.getTitle()), (Throwable)pe);
                }
            }
            catch (SystemException se) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)("Unable to obtain version " + version + " for external " + "repository file entry " + this.getTitle()), (Throwable)se);
            }
        }
        if (fileVersion != null && Validator.isNotNull((String)(mimeType = fileVersion.getMimeType()))) {
            return mimeType;
        }
        return MimeTypesUtil.getContentType((String)this.getTitle());
    }

    public Class<?> getModelClass() {
        return FileEntry.class;
    }

    @Override
    public String getName() {
        return this.getTitle();
    }

    public int getReadCount() {
        return 0;
    }

    public <T extends Capability> T getRepositoryCapability(Class<T> capabilityClass) {
        ExtRepositoryAdapter repository = this.getRepository();
        return (T)repository.getCapability(capabilityClass);
    }

    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFileEntryConstants.getClassName());
    }

    public String getTitle() {
        return this._extRepositoryFileEntry.getTitle();
    }

    public String getVersion() {
        try {
            List<ExtRepositoryFileVersionAdapter> extRepositoryFileVersionAdapters = this._getExtRepositoryFileVersionAdapters();
            FileVersion fileVersion = extRepositoryFileVersionAdapters.get(0);
            return fileVersion.getVersion();
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getVersionUserId() {
        return this.getUserId();
    }

    public String getVersionUserName() {
        return this.getUserName();
    }

    public String getVersionUserUuid() {
        return this.getUserUuid();
    }

    public boolean hasLock() {
        if (!this.isCheckedOut()) {
            return false;
        }
        User checkedOutByUser = this.getUser(this._extRepositoryFileEntry.getCheckedOutBy());
        return checkedOutByUser.getUserId() == PrincipalThreadLocal.getUserId();
    }

    public boolean isCheckedOut() {
        return !Validator.isNull((String)this._extRepositoryFileEntry.getCheckedOutBy());
    }

    public boolean isManualCheckInRequired() {
        return true;
    }

    public <T extends Capability> boolean isRepositoryCapabilityProvided(Class<T> capabilityClass) {
        ExtRepositoryAdapter repository = this.getRepository();
        return repository.isCapabilityProvided(capabilityClass);
    }

    public boolean isSupportsLocking() {
        return true;
    }

    private List<ExtRepositoryFileVersionAdapter> _getExtRepositoryFileVersionAdapters() throws PortalException {
        ExtRepositoryAdapter extRepositoryAdapter = this.getRepository();
        return extRepositoryAdapter.getExtRepositoryFileVersionAdapters(this);
    }
}

