/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external.cache;

import com.liferay.document.library.repository.external.cache.ConnectionBuilder;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.TransientValue;
import javax.servlet.http.HttpSession;

public class ConnectionCache<T> {
    private final ConnectionBuilder<T> _connectionBuilder;
    private final ThreadLocal<T> _connectionThreadLocal;
    private final String _sessionKey;

    public ConnectionCache(Class<T> connectionClass, long repositoryId, ConnectionBuilder<T> connectionBuilder) {
        this._connectionBuilder = connectionBuilder;
        this._sessionKey = ConnectionCache.class.getName() + "#" + repositoryId;
        this._connectionThreadLocal = new AutoResetThreadLocal(connectionClass.getName());
    }

    public T getConnection() throws RepositoryException {
        TransientValue transientValue;
        Object connection = null;
        HttpSession httpSession = PortalSessionThreadLocal.getHttpSession();
        if (httpSession != null) {
            transientValue = (TransientValue)httpSession.getAttribute(this._sessionKey);
            if (transientValue != null) {
                connection = transientValue.getValue();
            }
        } else {
            connection = this._connectionThreadLocal.get();
        }
        if (connection != null) {
            return (T)connection;
        }
        connection = this._connectionBuilder.buildConnection();
        if (httpSession != null) {
            transientValue = new TransientValue(connection);
            httpSession.setAttribute(this._sessionKey, (Object)transientValue);
        }
        this._connectionThreadLocal.set(connection);
        return (T)connection;
    }
}

