/*! npm.im/image-promise 5.0.1 */
'use strict';

Liferay.Loader.define('document-library-preview-document$image-promise@5.0.1/dist/image-promise.common-js', ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	function load(image) {
		if (!image) {
			return Promise.reject();
		} else if (typeof image === 'string') {
			/* Create a <img> from a string */
			var src = image;
			image = new Image();
			image.src = src;
		} else if (image.length !== undefined) {
			/* Treat as multiple images */

			// Momentarily ignore errors
			var reflected = [].map.call(image, function (img) {
				return load(img).catch(function (err) {
					return err;
				});
			});

			return Promise.all(reflected).then(function (results) {
				var loaded = results.filter(function (x) {
					return x.naturalWidth;
				});
				if (loaded.length === results.length) {
					return loaded;
				}
				return Promise.reject({
					loaded: loaded,
					errored: results.filter(function (x) {
						return !x.naturalWidth;
					})
				});
			});
		} else if (image.tagName !== 'IMG') {
			return Promise.reject();
		}

		var promise = new Promise(function (resolve, reject) {
			if (image.naturalWidth) {
				// If the browser can determine the naturalWidth the
				// image is already loaded successfully
				resolve(image);
			} else if (image.complete) {
				// If the image is complete but the naturalWidth is 0px
				// it is probably broken
				reject(image);
			} else {
				image.addEventListener('load', fullfill);
				image.addEventListener('error', fullfill);
			}
			function fullfill() {
				if (image.naturalWidth) {
					resolve(image);
				} else {
					reject(image);
				}
				image.removeEventListener('load', fullfill);
				image.removeEventListener('error', fullfill);
			}
		});
		promise.image = image;
		return promise;
	}

	module.exports = load;
});
//# sourceMappingURL=image-promise.common-js.js.map