/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.document.library.opener.model.impl;

import com.liferay.document.library.opener.model.DLOpenerFileEntryReference;
import com.liferay.document.library.opener.model.DLOpenerFileEntryReferenceModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DLOpenerFileEntryReference service. Represents a row in the &quot;DLOpenerFileEntryReference&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DLOpenerFileEntryReferenceModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DLOpenerFileEntryReferenceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLOpenerFileEntryReferenceImpl
 * @generated
 */
public class DLOpenerFileEntryReferenceModelImpl
	extends BaseModelImpl<DLOpenerFileEntryReference>
	implements DLOpenerFileEntryReferenceModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a dl opener file entry reference model instance should use the <code>DLOpenerFileEntryReference</code> interface instead.
	 */
	public static final String TABLE_NAME = "DLOpenerFileEntryReference";

	public static final Object[][] TABLE_COLUMNS = {
		{"dlOpenerFileEntryReferenceId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"referenceKey", Types.VARCHAR}, {"referenceType", Types.VARCHAR},
		{"fileEntryId", Types.BIGINT}, {"type_", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("dlOpenerFileEntryReferenceId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("referenceKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("referenceType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("type_", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DLOpenerFileEntryReference (dlOpenerFileEntryReferenceId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,referenceKey VARCHAR(75) null,referenceType VARCHAR(75) null,fileEntryId LONG,type_ INTEGER)";

	public static final String TABLE_SQL_DROP =
		"drop table DLOpenerFileEntryReference";

	public static final String ORDER_BY_JPQL =
		" ORDER BY dlOpenerFileEntryReference.dlOpenerFileEntryReferenceId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY DLOpenerFileEntryReference.dlOpenerFileEntryReferenceId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FILEENTRYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long REFERENCETYPE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DLOPENERFILEENTRYREFERENCEID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public DLOpenerFileEntryReferenceModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _dlOpenerFileEntryReferenceId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setDlOpenerFileEntryReferenceId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _dlOpenerFileEntryReferenceId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DLOpenerFileEntryReference.class;
	}

	@Override
	public String getModelClassName() {
		return DLOpenerFileEntryReference.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DLOpenerFileEntryReference, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DLOpenerFileEntryReference, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLOpenerFileEntryReference, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(DLOpenerFileEntryReference)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DLOpenerFileEntryReference, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DLOpenerFileEntryReference, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DLOpenerFileEntryReference)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DLOpenerFileEntryReference, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DLOpenerFileEntryReference, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<DLOpenerFileEntryReference, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<DLOpenerFileEntryReference, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String,
						 Function<DLOpenerFileEntryReference, Object>>();

			attributeGetterFunctions.put(
				"dlOpenerFileEntryReferenceId",
				DLOpenerFileEntryReference::getDlOpenerFileEntryReferenceId);
			attributeGetterFunctions.put(
				"groupId", DLOpenerFileEntryReference::getGroupId);
			attributeGetterFunctions.put(
				"companyId", DLOpenerFileEntryReference::getCompanyId);
			attributeGetterFunctions.put(
				"userId", DLOpenerFileEntryReference::getUserId);
			attributeGetterFunctions.put(
				"userName", DLOpenerFileEntryReference::getUserName);
			attributeGetterFunctions.put(
				"createDate", DLOpenerFileEntryReference::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", DLOpenerFileEntryReference::getModifiedDate);
			attributeGetterFunctions.put(
				"referenceKey", DLOpenerFileEntryReference::getReferenceKey);
			attributeGetterFunctions.put(
				"referenceType", DLOpenerFileEntryReference::getReferenceType);
			attributeGetterFunctions.put(
				"fileEntryId", DLOpenerFileEntryReference::getFileEntryId);
			attributeGetterFunctions.put(
				"type", DLOpenerFileEntryReference::getType);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<DLOpenerFileEntryReference, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<DLOpenerFileEntryReference, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<DLOpenerFileEntryReference, ?>>();

			attributeSetterBiConsumers.put(
				"dlOpenerFileEntryReferenceId",
				(BiConsumer<DLOpenerFileEntryReference, Long>)
					DLOpenerFileEntryReference::
						setDlOpenerFileEntryReferenceId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<DLOpenerFileEntryReference, Long>)
					DLOpenerFileEntryReference::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<DLOpenerFileEntryReference, Long>)
					DLOpenerFileEntryReference::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<DLOpenerFileEntryReference, Long>)
					DLOpenerFileEntryReference::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<DLOpenerFileEntryReference, String>)
					DLOpenerFileEntryReference::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<DLOpenerFileEntryReference, Date>)
					DLOpenerFileEntryReference::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<DLOpenerFileEntryReference, Date>)
					DLOpenerFileEntryReference::setModifiedDate);
			attributeSetterBiConsumers.put(
				"referenceKey",
				(BiConsumer<DLOpenerFileEntryReference, String>)
					DLOpenerFileEntryReference::setReferenceKey);
			attributeSetterBiConsumers.put(
				"referenceType",
				(BiConsumer<DLOpenerFileEntryReference, String>)
					DLOpenerFileEntryReference::setReferenceType);
			attributeSetterBiConsumers.put(
				"fileEntryId",
				(BiConsumer<DLOpenerFileEntryReference, Long>)
					DLOpenerFileEntryReference::setFileEntryId);
			attributeSetterBiConsumers.put(
				"type",
				(BiConsumer<DLOpenerFileEntryReference, Integer>)
					DLOpenerFileEntryReference::setType);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getDlOpenerFileEntryReferenceId() {
		return _dlOpenerFileEntryReferenceId;
	}

	@Override
	public void setDlOpenerFileEntryReferenceId(
		long dlOpenerFileEntryReferenceId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_dlOpenerFileEntryReferenceId = dlOpenerFileEntryReferenceId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getReferenceKey() {
		if (_referenceKey == null) {
			return "";
		}
		else {
			return _referenceKey;
		}
	}

	@Override
	public void setReferenceKey(String referenceKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_referenceKey = referenceKey;
	}

	@Override
	public String getReferenceType() {
		if (_referenceType == null) {
			return "";
		}
		else {
			return _referenceType;
		}
	}

	@Override
	public void setReferenceType(String referenceType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_referenceType = referenceType;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalReferenceType() {
		return getColumnOriginalValue("referenceType");
	}

	@Override
	public long getFileEntryId() {
		return _fileEntryId;
	}

	@Override
	public void setFileEntryId(long fileEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fileEntryId = fileEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFileEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("fileEntryId"));
	}

	@Override
	public int getType() {
		return _type;
	}

	@Override
	public void setType(int type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DLOpenerFileEntryReference.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public DLOpenerFileEntryReference toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DLOpenerFileEntryReference>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DLOpenerFileEntryReferenceImpl dlOpenerFileEntryReferenceImpl =
			new DLOpenerFileEntryReferenceImpl();

		dlOpenerFileEntryReferenceImpl.setDlOpenerFileEntryReferenceId(
			getDlOpenerFileEntryReferenceId());
		dlOpenerFileEntryReferenceImpl.setGroupId(getGroupId());
		dlOpenerFileEntryReferenceImpl.setCompanyId(getCompanyId());
		dlOpenerFileEntryReferenceImpl.setUserId(getUserId());
		dlOpenerFileEntryReferenceImpl.setUserName(getUserName());
		dlOpenerFileEntryReferenceImpl.setCreateDate(getCreateDate());
		dlOpenerFileEntryReferenceImpl.setModifiedDate(getModifiedDate());
		dlOpenerFileEntryReferenceImpl.setReferenceKey(getReferenceKey());
		dlOpenerFileEntryReferenceImpl.setReferenceType(getReferenceType());
		dlOpenerFileEntryReferenceImpl.setFileEntryId(getFileEntryId());
		dlOpenerFileEntryReferenceImpl.setType(getType());

		dlOpenerFileEntryReferenceImpl.resetOriginalValues();

		return dlOpenerFileEntryReferenceImpl;
	}

	@Override
	public DLOpenerFileEntryReference cloneWithOriginalValues() {
		DLOpenerFileEntryReferenceImpl dlOpenerFileEntryReferenceImpl =
			new DLOpenerFileEntryReferenceImpl();

		dlOpenerFileEntryReferenceImpl.setDlOpenerFileEntryReferenceId(
			this.<Long>getColumnOriginalValue("dlOpenerFileEntryReferenceId"));
		dlOpenerFileEntryReferenceImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		dlOpenerFileEntryReferenceImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		dlOpenerFileEntryReferenceImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		dlOpenerFileEntryReferenceImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		dlOpenerFileEntryReferenceImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		dlOpenerFileEntryReferenceImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		dlOpenerFileEntryReferenceImpl.setReferenceKey(
			this.<String>getColumnOriginalValue("referenceKey"));
		dlOpenerFileEntryReferenceImpl.setReferenceType(
			this.<String>getColumnOriginalValue("referenceType"));
		dlOpenerFileEntryReferenceImpl.setFileEntryId(
			this.<Long>getColumnOriginalValue("fileEntryId"));
		dlOpenerFileEntryReferenceImpl.setType(
			this.<Integer>getColumnOriginalValue("type_"));

		return dlOpenerFileEntryReferenceImpl;
	}

	@Override
	public int compareTo(
		DLOpenerFileEntryReference dlOpenerFileEntryReference) {

		long primaryKey = dlOpenerFileEntryReference.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DLOpenerFileEntryReference)) {
			return false;
		}

		DLOpenerFileEntryReference dlOpenerFileEntryReference =
			(DLOpenerFileEntryReference)object;

		long primaryKey = dlOpenerFileEntryReference.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<DLOpenerFileEntryReference> toCacheModel() {
		DLOpenerFileEntryReferenceCacheModel
			dlOpenerFileEntryReferenceCacheModel =
				new DLOpenerFileEntryReferenceCacheModel();

		dlOpenerFileEntryReferenceCacheModel.dlOpenerFileEntryReferenceId =
			getDlOpenerFileEntryReferenceId();

		dlOpenerFileEntryReferenceCacheModel.groupId = getGroupId();

		dlOpenerFileEntryReferenceCacheModel.companyId = getCompanyId();

		dlOpenerFileEntryReferenceCacheModel.userId = getUserId();

		dlOpenerFileEntryReferenceCacheModel.userName = getUserName();

		String userName = dlOpenerFileEntryReferenceCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			dlOpenerFileEntryReferenceCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			dlOpenerFileEntryReferenceCacheModel.createDate =
				createDate.getTime();
		}
		else {
			dlOpenerFileEntryReferenceCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			dlOpenerFileEntryReferenceCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			dlOpenerFileEntryReferenceCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		dlOpenerFileEntryReferenceCacheModel.referenceKey = getReferenceKey();

		String referenceKey = dlOpenerFileEntryReferenceCacheModel.referenceKey;

		if ((referenceKey != null) && (referenceKey.length() == 0)) {
			dlOpenerFileEntryReferenceCacheModel.referenceKey = null;
		}

		dlOpenerFileEntryReferenceCacheModel.referenceType = getReferenceType();

		String referenceType =
			dlOpenerFileEntryReferenceCacheModel.referenceType;

		if ((referenceType != null) && (referenceType.length() == 0)) {
			dlOpenerFileEntryReferenceCacheModel.referenceType = null;
		}

		dlOpenerFileEntryReferenceCacheModel.fileEntryId = getFileEntryId();

		dlOpenerFileEntryReferenceCacheModel.type = getType();

		return dlOpenerFileEntryReferenceCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<DLOpenerFileEntryReference, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<DLOpenerFileEntryReference, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLOpenerFileEntryReference, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(DLOpenerFileEntryReference)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, DLOpenerFileEntryReference>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						DLOpenerFileEntryReference.class, ModelWrapper.class);

	}

	private long _dlOpenerFileEntryReferenceId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _referenceKey;
	private String _referenceType;
	private long _fileEntryId;
	private int _type;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<DLOpenerFileEntryReference, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((DLOpenerFileEntryReference)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put(
			"dlOpenerFileEntryReferenceId", _dlOpenerFileEntryReferenceId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("referenceKey", _referenceKey);
		_columnOriginalValues.put("referenceType", _referenceType);
		_columnOriginalValues.put("fileEntryId", _fileEntryId);
		_columnOriginalValues.put("type_", _type);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("dlOpenerFileEntryReferenceId", 1L);

		columnBitmasks.put("groupId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("referenceKey", 128L);

		columnBitmasks.put("referenceType", 256L);

		columnBitmasks.put("fileEntryId", 512L);

		columnBitmasks.put("type_", 1024L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private DLOpenerFileEntryReference _escapedModel;

}