/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.opener.internal.upload;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.opener.upload.UniqueFileEntryTitleProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.upload.UniqueFileNameProvider;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UniqueFileEntryTitleProvider.class})
public class UniqueFileEntryTitleProviderImpl
implements UniqueFileEntryTitleProvider {
    private static final Log _log = LogFactoryUtil.getLog(UniqueFileEntryTitleProviderImpl.class);
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private Language _language;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    public String provide(long groupId, long folderId, Locale locale) throws PortalException {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)locale, UniqueFileEntryTitleProviderImpl.class);
        return this._provide(groupId, folderId, this._language.get(resourceBundle, "untitled"));
    }

    public String provide(long groupId, long folderId, String fileName) throws PortalException {
        return this._provide(groupId, folderId, fileName);
    }

    private boolean _exists(long groupId, long folderId, String fileName) {
        try {
            this._dlAppLocalService.getFileEntry(groupId, folderId, fileName);
            return true;
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchFileEntryException, (Throwable)noSuchFileEntryException);
            }
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
        return false;
    }

    private String _provide(long groupId, long folderId, String fileName) throws PortalException {
        return this._uniqueFileNameProvider.provide(fileName, generatedFileName -> this._exists(groupId, folderId, (String)generatedFileName));
    }
}

