/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.file.rank.service.impl;

import com.liferay.document.library.file.rank.internal.configuration.DLFileRankServiceConfiguration;
import com.liferay.document.library.file.rank.model.DLFileRank;
import com.liferay.document.library.file.rank.service.base.DLFileRankLocalServiceBaseImpl;
import com.liferay.document.library.file.rank.util.comparator.FileRankCreateDateComparator;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class DLFileRankLocalServiceImpl
extends DLFileRankLocalServiceBaseImpl {
    @ServiceReference(type=ConfigurationProvider.class)
    protected ConfigurationProvider configurationProvider;
    private static final Log _log = LogFactoryUtil.getLog(DLFileRankLocalServiceImpl.class);

    public DLFileRank addFileRank(long groupId, long companyId, long userId, long fileEntryId, ServiceContext serviceContext) {
        DLFileRank dlFileRank;
        block3: {
            long fileRankId = this.counterLocalService.increment();
            dlFileRank = this.dlFileRankPersistence.create(fileRankId);
            dlFileRank.setGroupId(groupId);
            dlFileRank.setCompanyId(companyId);
            dlFileRank.setUserId(userId);
            dlFileRank.setCreateDate(serviceContext.getCreateDate(null));
            dlFileRank.setFileEntryId(fileEntryId);
            dlFileRank.setActive(true);
            try {
                dlFileRank = (DLFileRank)this.dlFileRankPersistence.update((BaseModel)dlFileRank);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Add failed, fetch {companyId=", companyId, ", userId=", userId, ", fileEntryId=", fileEntryId, "}"}));
                }
                if ((dlFileRank = this.dlFileRankPersistence.fetchByC_U_F(companyId, userId, fileEntryId, false)) != null) break block3;
                throw se;
            }
        }
        return dlFileRank;
    }

    public void checkFileRanks() {
        int maxSize = this._getMaxSize();
        List staleFileRanks = this.dlFileRankFinder.findByStaleRanks(maxSize);
        for (Object[] staleFileRank : staleFileRanks) {
            long groupId = (Long)staleFileRank[0];
            long userId = (Long)staleFileRank[1];
            List dlFileRanks = this.dlFileRankPersistence.findByG_U_A(groupId, userId, true, maxSize, -1, (OrderByComparator)new FileRankCreateDateComparator());
            for (DLFileRank dlFileRank : dlFileRanks) {
                long fileRankId = dlFileRank.getFileRankId();
                try {
                    this.dlFileRankPersistence.remove((BaseModel)dlFileRank);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to remove file rank " + fileRankId));
                }
            }
        }
    }

    @SystemEvent(type=1)
    public void deleteFileRank(DLFileRank dlFileRank) {
        this.dlFileRankPersistence.remove((BaseModel)dlFileRank);
    }

    public void deleteFileRank(long fileRankId) throws PortalException {
        DLFileRank dlFileRank = this.dlFileRankPersistence.findByPrimaryKey(fileRankId);
        this.dlFileRankLocalService.deleteFileRank(dlFileRank);
    }

    public void deleteFileRanksByFileEntryId(long fileEntryId) {
        List dlFileRanks = this.dlFileRankPersistence.findByFileEntryId(fileEntryId);
        for (DLFileRank dlFileRank : dlFileRanks) {
            this.dlFileRankLocalService.deleteFileRank(dlFileRank);
        }
    }

    public void deleteFileRanksByUserId(long userId) {
        List dlFileRanks = this.dlFileRankPersistence.findByUserId(userId);
        for (DLFileRank dlFileRank : dlFileRanks) {
            this.dlFileRankLocalService.deleteFileRank(dlFileRank);
        }
    }

    public void disableFileRanks(long fileEntryId) {
        List dlFileRanks = this.dlFileRankPersistence.findByFileEntryId(fileEntryId);
        for (DLFileRank dlFileRank : dlFileRanks) {
            dlFileRank.setActive(false);
            this.dlFileRankPersistence.update((BaseModel)dlFileRank);
        }
    }

    public void disableFileRanksByFolderId(long folderId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getDLFolder(folderId);
        this.updateFileRanks(dlFolder, false);
    }

    public void enableFileRanks(long fileEntryId) {
        List dlFileRanks = this.dlFileRankPersistence.findByFileEntryId(fileEntryId);
        for (DLFileRank dlFileRank : dlFileRanks) {
            dlFileRank.setActive(true);
            this.dlFileRankPersistence.update((BaseModel)dlFileRank);
        }
    }

    public void enableFileRanksByFolderId(long folderId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getDLFolder(folderId);
        this.updateFileRanks(dlFolder, true);
    }

    public List<DLFileRank> getFileRanks(long groupId, long userId) {
        int maxSize = this._getMaxSize();
        return this.dlFileRankPersistence.findByG_U_A(groupId, userId, true, 0, maxSize, (OrderByComparator)new FileRankCreateDateComparator());
    }

    public DLFileRank updateFileRank(long groupId, long companyId, long userId, long fileEntryId, ServiceContext serviceContext) {
        DLFileRank dlFileRank = this.dlFileRankPersistence.fetchByC_U_F(companyId, userId, fileEntryId);
        if (dlFileRank != null) {
            dlFileRank.setCreateDate(serviceContext.getCreateDate(null));
            try {
                dlFileRank = (DLFileRank)this.dlFileRankPersistence.update((BaseModel)dlFileRank);
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Update failed, fetch {companyId=", companyId, ", userId=", userId, ", fileEntryId=", fileEntryId, "}"}));
                }
            }
        } else {
            dlFileRank = this.addFileRank(groupId, companyId, userId, fileEntryId, serviceContext);
        }
        return dlFileRank;
    }

    protected void updateFileRanks(DLFolder dlFolder, boolean active) {
        List dlFolders = this.dlFolderLocalService.getFolders(dlFolder.getGroupId(), dlFolder.getFolderId());
        for (DLFolder curDLFolder : dlFolders) {
            this.updateFileRanks(curDLFolder, active);
        }
        List dlFileRanks = this.dlFileRankFinder.findByFolderId(dlFolder.getFolderId());
        for (DLFileRank dlFileRank : dlFileRanks) {
            dlFileRank.setActive(active);
            this.dlFileRankPersistence.update((BaseModel)dlFileRank);
        }
    }

    private int _getMaxSize() {
        int maxSize = 5;
        try {
            DLFileRankServiceConfiguration dlFileRankServiceConfiguration = (DLFileRankServiceConfiguration)this.configurationProvider.getSystemConfiguration(DLFileRankServiceConfiguration.class);
            maxSize = dlFileRankServiceConfiguration.maxSize();
        }
        catch (ConfigurationException ce) {
            _log.error((Object)"Unable to get document library file rank service configuration", (Throwable)ce);
        }
        return maxSize;
    }
}

