/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.document.conversion.internal.background.task;

import com.liferay.document.library.kernel.processor.DLProcessor;
import com.liferay.document.library.kernel.processor.PDFProcessor;
import com.liferay.document.library.preview.background.task.BasePreviewBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"background.task.executor.class.name=com.liferay.document.library.document.conversion.internal.background.task.OpenOfficeConversionPreviewBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class OpenOfficeConversionPreviewBackgroundTaskExecutor
extends BasePreviewBackgroundTaskExecutor {
    @Reference(target="(type=PDFProcessor)")
    private DLProcessor _dlProcessor;

    protected void generatePreview(FileVersion fileVersion) throws Exception {
        PDFProcessor pdfProcessor = (PDFProcessor)this._dlProcessor;
        pdfProcessor.generateImages(null, fileVersion);
    }

    protected String[] getMimeTypes() {
        return MimeTypesHolder.getMimeTypes();
    }

    private static class MimeTypesHolder {
        private static final List<String> _mimeTypes = new ArrayList<String>();

        private MimeTypesHolder() {
        }

        public static String[] getMimeTypes() {
            return _mimeTypes.toArray(new String[0]);
        }

        private static void _populateMimeTypeList(String documentFamily) {
            String[] sourceExtensions;
            Filter filter = new Filter(documentFamily);
            for (String sourceExtension : sourceExtensions = PropsUtil.getArray((String)"openoffice.conversion.source.extensions", (Filter)filter)) {
                String contentType = MimeTypesUtil.getExtensionContentType((String)sourceExtension);
                if (Validator.isNull((String)contentType)) continue;
                _mimeTypes.add(contentType);
            }
        }

        static {
            MimeTypesHolder._populateMimeTypeList("drawing");
            MimeTypesHolder._populateMimeTypeList("presentation");
            MimeTypesHolder._populateMimeTypeList("spreadsheet");
            MimeTypesHolder._populateMimeTypeList("text");
        }
    }
}

