/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.document.library.document.conversion.internal.configuration;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

/**
 * @author Pei-Jung Lan
 */
@ExtendedObjectClassDefinition(category = "connectors")
@Meta.OCD(
	id = "com.liferay.document.library.document.conversion.internal.configuration.OpenOfficeConfiguration",
	localization = "content/Language", name = "openoffice-configuration-name"
)
public interface OpenOfficeConfiguration {

	@Meta.AD(deflt = "true", name = "cache-enabled", required = false)
	public boolean cacheEnabled();

	@Meta.AD(
		deflt = "false", description = "openoffice-server-enabled-help",
		name = "server-enabled", required = false
	)
	public boolean serverEnabled();

	@Meta.AD(deflt = "127.0.0.1", name = "server-host", required = false)
	public String serverHost();

	@Meta.AD(deflt = "8100", name = "server-port", required = false)
	public int serverPort();

}