/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.content.service.impl;

import com.liferay.document.library.content.exception.NoSuchContentException;
import com.liferay.document.library.content.model.DLContent;
import com.liferay.document.library.content.service.base.DLContentLocalServiceBaseImpl;
import com.liferay.document.library.content.util.comparator.DLContentVersionComparator;
import com.liferay.petra.io.StreamUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.sql.Blob;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.document.library.content.model.DLContent"}, service={AopService.class})
public class DLContentLocalServiceImpl
extends DLContentLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLContentLocalServiceImpl.class);

    @Deprecated
    public DLContent addContent(long companyId, long repositoryId, String path, String version, byte[] bytes) {
        long contentId = this.counterLocalService.increment();
        DLContent dlContent = this.dlContentPersistence.create(contentId);
        dlContent.setCompanyId(companyId);
        dlContent.setRepositoryId(repositoryId);
        dlContent.setPath(path);
        dlContent.setVersion(version);
        com.liferay.petra.io.unsync.UnsyncByteArrayInputStream unsyncByteArrayInputStream = new com.liferay.petra.io.unsync.UnsyncByteArrayInputStream(bytes);
        OutputBlob dataOutputBlob = new OutputBlob((InputStream)unsyncByteArrayInputStream, (long)bytes.length);
        dlContent.setData((Blob)dataOutputBlob);
        dlContent.setSize((long)bytes.length);
        return (DLContent)this.dlContentPersistence.update((BaseModel)dlContent);
    }

    public DLContent addContent(long companyId, long repositoryId, String path, String version, InputStream inputStream) {
        DLContent dlContent = this.dlContentPersistence.fetchByC_R_P_V(companyId, repositoryId, path, version);
        if (dlContent == null) {
            dlContent = this.dlContentPersistence.create(this.counterLocalService.increment());
            dlContent.setCompanyId(companyId);
            dlContent.setRepositoryId(repositoryId);
            dlContent.setPath(path);
            dlContent.setVersion(version);
        }
        OutputBlob outputBlob = this._toOutputBlob(inputStream);
        dlContent.setData((Blob)outputBlob);
        dlContent.setSize(outputBlob.length());
        return (DLContent)this.dlContentPersistence.update((BaseModel)dlContent);
    }

    @Deprecated
    public DLContent addContent(long companyId, long repositoryId, String path, String version, InputStream inputStream, long size) {
        DLContent dlContent;
        block14: {
            dlContent = null;
            try (InputStream copyInputStream = inputStream;){
                long contentId = this.counterLocalService.increment();
                dlContent = this.dlContentPersistence.create(contentId);
                dlContent.setCompanyId(companyId);
                dlContent.setRepositoryId(repositoryId);
                dlContent.setPath(path);
                dlContent.setVersion(version);
                OutputBlob dataOutputBlob = new OutputBlob(copyInputStream, size);
                dlContent.setData((Blob)dataOutputBlob);
                dlContent.setSize(size);
                dlContent = (DLContent)this.dlContentPersistence.update((BaseModel)dlContent);
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Throwable)ioException);
            }
        }
        return dlContent;
    }

    public void deleteContent(long companyId, long repositoryId, String path, String version) {
        DLContent dlContent = this.dlContentPersistence.fetchByC_R_P_V(companyId, repositoryId, path, version);
        if (dlContent != null) {
            this.dlContentPersistence.remove((BaseModel)dlContent);
        }
    }

    @Deprecated
    public void deleteContents(long companyId, long repositoryId, String path) {
        this.dlContentPersistence.removeByC_R_P(companyId, repositoryId, path);
    }

    public void deleteContentsByDirectory(long companyId, long repositoryId, String dirName) {
        if (dirName.isEmpty()) {
            this.dlContentPersistence.removeByC_R(companyId, repositoryId);
            return;
        }
        if (!dirName.endsWith("/")) {
            dirName = dirName.concat("/");
        }
        dirName = dirName.concat("%");
        this.dlContentPersistence.removeByC_R_LikeP(companyId, repositoryId, dirName);
    }

    @Deprecated
    public DLContent getContent(long companyId, long repositoryId, String path) throws NoSuchContentException {
        DLContentVersionComparator orderByComparator = new DLContentVersionComparator();
        List dlContents = this.dlContentPersistence.findByC_R_P(companyId, repositoryId, path, 0, 1, (OrderByComparator)orderByComparator);
        if (ListUtil.isEmpty((List)dlContents)) {
            throw new NoSuchContentException(path);
        }
        return (DLContent)dlContents.get(0);
    }

    public DLContent getContent(long companyId, long repositoryId, String path, String version) throws NoSuchContentException {
        if (version.isEmpty()) {
            DLContentVersionComparator orderByComparator = new DLContentVersionComparator();
            List dlContents = this.dlContentPersistence.findByC_R_P(companyId, repositoryId, path, 0, 1, (OrderByComparator)orderByComparator);
            if (ListUtil.isEmpty((List)dlContents)) {
                throw new NoSuchContentException(path);
            }
            return (DLContent)dlContents.get(0);
        }
        return this.dlContentPersistence.findByC_R_P_V(companyId, repositoryId, path, version);
    }

    @Deprecated
    public List<DLContent> getContents(long companyId, long repositoryId) {
        return this.dlContentPersistence.findByC_R(companyId, repositoryId);
    }

    public List<DLContent> getContents(long companyId, long repositoryId, String path) {
        return this.dlContentPersistence.findByC_R_P(companyId, repositoryId, path);
    }

    public List<DLContent> getContentsByDirectory(long companyId, long repositoryId, String dirName) {
        if (dirName.isEmpty()) {
            return this.dlContentPersistence.findByC_R(companyId, repositoryId);
        }
        if (!dirName.endsWith("/")) {
            dirName = dirName.concat("/");
        }
        dirName = dirName.concat("%");
        return this.dlContentPersistence.findByC_R_LikeP(companyId, repositoryId, dirName);
    }

    public boolean hasContent(long companyId, long repositoryId, String path, String version) {
        int count = this.dlContentPersistence.countByC_R_P_V(companyId, repositoryId, path, version);
        return count > 0;
    }

    @Deprecated
    public void updateDLContent(long companyId, long oldRepositoryId, long newRepositoryId, String oldPath, String newPath) {
        List dlContents = this.dlContentPersistence.findByC_R_P(companyId, oldRepositoryId, oldPath);
        for (DLContent dLContent : dlContents) {
            dLContent.setRepositoryId(newRepositoryId);
            dLContent.setPath(newPath);
            this.dlContentPersistence.update((BaseModel)dLContent);
        }
    }

    private OutputBlob _toOutputBlob(InputStream inputStream) {
        block8: {
            if (inputStream instanceof ByteArrayInputStream) {
                ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)inputStream;
                return new OutputBlob(inputStream, (long)byteArrayInputStream.available());
            }
            if (inputStream instanceof com.liferay.petra.io.unsync.UnsyncByteArrayInputStream) {
                com.liferay.petra.io.unsync.UnsyncByteArrayInputStream unsyncByteArrayInputStream = (com.liferay.petra.io.unsync.UnsyncByteArrayInputStream)inputStream;
                return new OutputBlob((InputStream)unsyncByteArrayInputStream, (long)unsyncByteArrayInputStream.available());
            }
            if (inputStream instanceof UnsyncByteArrayInputStream) {
                UnsyncByteArrayInputStream unsyncByteArrayInputStream = (UnsyncByteArrayInputStream)inputStream;
                return new OutputBlob(inputStream, (long)unsyncByteArrayInputStream.available());
            }
            if (inputStream instanceof FileInputStream) {
                FileInputStream fileInputStream = (FileInputStream)inputStream;
                FileChannel fileChannel = fileInputStream.getChannel();
                try {
                    return new OutputBlob(inputStream, fileChannel.size());
                }
                catch (IOException ioException) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)"Unable to detect file size from file channel", (Throwable)ioException);
                }
            }
        }
        try {
            byte[] bytes = StreamUtil.toByteArray((InputStream)inputStream);
            com.liferay.petra.io.unsync.UnsyncByteArrayInputStream unsyncByteArrayInputStream = new com.liferay.petra.io.unsync.UnsyncByteArrayInputStream(bytes);
            return new OutputBlob((InputStream)unsyncByteArrayInputStream, (long)bytes.length);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }
}

