/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.document.library.content.model.impl;

import com.liferay.document.library.content.model.DLContent;
import com.liferay.document.library.content.model.DLContentDataBlobModel;
import com.liferay.document.library.content.model.DLContentModel;
import com.liferay.document.library.content.service.DLContentLocalServiceUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DLContent service. Represents a row in the &quot;DLContent&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DLContentModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DLContentImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLContentImpl
 * @generated
 */
public class DLContentModelImpl
	extends BaseModelImpl<DLContent> implements DLContentModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a document library content model instance should use the <code>DLContent</code> interface instead.
	 */
	public static final String TABLE_NAME = "DLContent";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"contentId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"repositoryId", Types.BIGINT}, {"path_", Types.VARCHAR},
		{"version", Types.VARCHAR}, {"data_", Types.BLOB},
		{"size_", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("contentId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("repositoryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("path_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("version", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("data_", Types.BLOB);
		TABLE_COLUMNS_MAP.put("size_", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DLContent (mvccVersion LONG default 0 not null,contentId LONG not null primary key,groupId LONG,companyId LONG,repositoryId LONG,path_ VARCHAR(255) null,version VARCHAR(75) null,data_ BLOB,size_ LONG)";

	public static final String TABLE_SQL_DROP = "drop table DLContent";

	public static final String ORDER_BY_JPQL =
		" ORDER BY dlContent.version DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY DLContent.version DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	public static final long PATH_COLUMN_BITMASK = 2L;

	public static final long REPOSITORYID_COLUMN_BITMASK = 4L;

	public static final long VERSION_COLUMN_BITMASK = 8L;

	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
		_entityCacheEnabled = entityCacheEnabled;
	}

	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
		_finderCacheEnabled = finderCacheEnabled;
	}

	public DLContentModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _contentId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setContentId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _contentId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DLContent.class;
	}

	@Override
	public String getModelClassName() {
		return DLContent.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DLContent, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DLContent, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLContent, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((DLContent)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DLContent, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DLContent, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DLContent)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DLContent, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DLContent, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<DLContent, Object>>
		_attributeGetterFunctions;

	static {
		Map<String, Function<DLContent, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<DLContent, Object>>();

		attributeGetterFunctions.put("mvccVersion", DLContent::getMvccVersion);
		attributeGetterFunctions.put("contentId", DLContent::getContentId);
		attributeGetterFunctions.put("groupId", DLContent::getGroupId);
		attributeGetterFunctions.put("companyId", DLContent::getCompanyId);
		attributeGetterFunctions.put(
			"repositoryId", DLContent::getRepositoryId);
		attributeGetterFunctions.put("path", DLContent::getPath);
		attributeGetterFunctions.put("version", DLContent::getVersion);
		attributeGetterFunctions.put("data", DLContent::getData);
		attributeGetterFunctions.put("size", DLContent::getSize);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map<String, BiConsumer<DLContent, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<DLContent, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<DLContent, ?>>();

		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<DLContent, Long>)DLContent::setMvccVersion);
		attributeSetterBiConsumers.put(
			"contentId", (BiConsumer<DLContent, Long>)DLContent::setContentId);
		attributeSetterBiConsumers.put(
			"groupId", (BiConsumer<DLContent, Long>)DLContent::setGroupId);
		attributeSetterBiConsumers.put(
			"companyId", (BiConsumer<DLContent, Long>)DLContent::setCompanyId);
		attributeSetterBiConsumers.put(
			"repositoryId",
			(BiConsumer<DLContent, Long>)DLContent::setRepositoryId);
		attributeSetterBiConsumers.put(
			"path", (BiConsumer<DLContent, String>)DLContent::setPath);
		attributeSetterBiConsumers.put(
			"version", (BiConsumer<DLContent, String>)DLContent::setVersion);
		attributeSetterBiConsumers.put(
			"data", (BiConsumer<DLContent, Blob>)DLContent::setData);
		attributeSetterBiConsumers.put(
			"size", (BiConsumer<DLContent, Long>)DLContent::setSize);

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		_mvccVersion = mvccVersion;
	}

	@Override
	public long getContentId() {
		return _contentId;
	}

	@Override
	public void setContentId(long contentId) {
		_contentId = contentId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_groupId = groupId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@Override
	public long getRepositoryId() {
		return _repositoryId;
	}

	@Override
	public void setRepositoryId(long repositoryId) {
		_columnBitmask |= REPOSITORYID_COLUMN_BITMASK;

		if (!_setOriginalRepositoryId) {
			_setOriginalRepositoryId = true;

			_originalRepositoryId = _repositoryId;
		}

		_repositoryId = repositoryId;
	}

	public long getOriginalRepositoryId() {
		return _originalRepositoryId;
	}

	@Override
	public String getPath() {
		if (_path == null) {
			return "";
		}
		else {
			return _path;
		}
	}

	@Override
	public void setPath(String path) {
		_columnBitmask |= PATH_COLUMN_BITMASK;

		if (_originalPath == null) {
			_originalPath = _path;
		}

		_path = path;
	}

	public String getOriginalPath() {
		return GetterUtil.getString(_originalPath);
	}

	@Override
	public String getVersion() {
		if (_version == null) {
			return "";
		}
		else {
			return _version;
		}
	}

	@Override
	public void setVersion(String version) {
		_columnBitmask = -1L;

		if (_originalVersion == null) {
			_originalVersion = _version;
		}

		_version = version;
	}

	public String getOriginalVersion() {
		return GetterUtil.getString(_originalVersion);
	}

	@Override
	public Blob getData() {
		if (_dataBlobModel == null) {
			try {
				_dataBlobModel = DLContentLocalServiceUtil.getDataBlobModel(
					getPrimaryKey());
			}
			catch (Exception exception) {
			}
		}

		Blob blob = null;

		if (_dataBlobModel != null) {
			blob = _dataBlobModel.getDataBlob();
		}

		return blob;
	}

	@Override
	public void setData(Blob data) {
		if (_dataBlobModel == null) {
			_dataBlobModel = new DLContentDataBlobModel(getPrimaryKey(), data);
		}
		else {
			_dataBlobModel.setDataBlob(data);
		}
	}

	@Override
	public long getSize() {
		return _size;
	}

	@Override
	public void setSize(long size) {
		_size = size;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DLContent.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public DLContent toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DLContent>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DLContentImpl dlContentImpl = new DLContentImpl();

		dlContentImpl.setMvccVersion(getMvccVersion());
		dlContentImpl.setContentId(getContentId());
		dlContentImpl.setGroupId(getGroupId());
		dlContentImpl.setCompanyId(getCompanyId());
		dlContentImpl.setRepositoryId(getRepositoryId());
		dlContentImpl.setPath(getPath());
		dlContentImpl.setVersion(getVersion());
		dlContentImpl.setSize(getSize());

		dlContentImpl.resetOriginalValues();

		return dlContentImpl;
	}

	@Override
	public int compareTo(DLContent dlContent) {
		int value = 0;

		value = getVersion().compareTo(dlContent.getVersion());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DLContent)) {
			return false;
		}

		DLContent dlContent = (DLContent)object;

		long primaryKey = dlContent.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return _entityCacheEnabled;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return _finderCacheEnabled;
	}

	@Override
	public void resetOriginalValues() {
		_originalCompanyId = _companyId;

		_setOriginalCompanyId = false;

		_originalRepositoryId = _repositoryId;

		_setOriginalRepositoryId = false;

		_originalPath = _path;

		_originalVersion = _version;

		_dataBlobModel = null;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<DLContent> toCacheModel() {
		DLContentCacheModel dlContentCacheModel = new DLContentCacheModel();

		dlContentCacheModel.mvccVersion = getMvccVersion();

		dlContentCacheModel.contentId = getContentId();

		dlContentCacheModel.groupId = getGroupId();

		dlContentCacheModel.companyId = getCompanyId();

		dlContentCacheModel.repositoryId = getRepositoryId();

		dlContentCacheModel.path = getPath();

		String path = dlContentCacheModel.path;

		if ((path != null) && (path.length() == 0)) {
			dlContentCacheModel.path = null;
		}

		dlContentCacheModel.version = getVersion();

		String version = dlContentCacheModel.version;

		if ((version != null) && (version.length() == 0)) {
			dlContentCacheModel.version = null;
		}

		dlContentCacheModel.size = getSize();

		return dlContentCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(19);

		sb.append("{\"mvccVersion\": ");

		sb.append(getMvccVersion());

		sb.append(", \"contentId\": ");

		sb.append(getContentId());

		sb.append(", \"groupId\": ");

		sb.append(getGroupId());

		sb.append(", \"companyId\": ");

		sb.append(getCompanyId());

		sb.append(", \"repositoryId\": ");

		sb.append(getRepositoryId());

		sb.append(", \"path\": ");

		sb.append("\"" + getPath() + "\"");

		sb.append(", \"version\": ");

		sb.append("\"" + getVersion() + "\"");

		sb.append(", \"size\": ");

		sb.append(getSize());

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(31);

		sb.append("<model><model-name>");
		sb.append("com.liferay.document.library.content.model.DLContent");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>mvccVersion</column-name><column-value><![CDATA[");

		sb.append(getMvccVersion());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>contentId</column-name><column-value><![CDATA[");

		sb.append(getContentId());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");

		sb.append(getGroupId());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");

		sb.append(getCompanyId());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>repositoryId</column-name><column-value><![CDATA[");

		sb.append(getRepositoryId());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>path</column-name><column-value><![CDATA[");

		sb.append(getPath());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>version</column-name><column-value><![CDATA[");

		sb.append(getVersion());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>size</column-name><column-value><![CDATA[");

		sb.append(getSize());

		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, DLContent>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					DLContent.class, ModelWrapper.class);

	}

	private static boolean _entityCacheEnabled;
	private static boolean _finderCacheEnabled;

	private long _mvccVersion;
	private long _contentId;
	private long _groupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _repositoryId;
	private long _originalRepositoryId;
	private boolean _setOriginalRepositoryId;
	private String _path;
	private String _originalPath;
	private String _version;
	private String _originalVersion;
	private DLContentDataBlobModel _dataBlobModel;
	private long _size;
	private long _columnBitmask;
	private DLContent _escapedModel;

}