/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.model.impl;

import com.liferay.dispatch.executor.DispatchTaskStatus;
import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.model.impl.DispatchTriggerBaseImpl;
import com.liferay.dispatch.service.DispatchLogLocalServiceUtil;
import com.liferay.dispatch.service.DispatchTriggerLocalServiceUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import java.util.Date;
import java.util.TimeZone;

public class DispatchTriggerImpl
extends DispatchTriggerBaseImpl {
    private transient UnicodeProperties _dispatchTaskSettingsUnicodeProperties;
    private transient DispatchTaskStatus _dispatchTaskStatus;
    private transient Date _nextFireDate;

    public UnicodeProperties getDispatchTaskSettingsUnicodeProperties() {
        if (this._dispatchTaskSettingsUnicodeProperties == null) {
            this._dispatchTaskSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(this.getDispatchTaskSettings()).build();
        }
        return this._dispatchTaskSettingsUnicodeProperties;
    }

    public DispatchTaskStatus getDispatchTaskStatus() {
        if (this._dispatchTaskStatus != null) {
            return this._dispatchTaskStatus;
        }
        DispatchLog dispatchLog = DispatchLogLocalServiceUtil.fetchLatestDispatchLog((long)this.getDispatchTriggerId());
        if (dispatchLog == null) {
            return DispatchTaskStatus.NEVER_RAN;
        }
        this._dispatchTaskStatus = DispatchTaskStatus.valueOf((int)dispatchLog.getStatus());
        return this._dispatchTaskStatus;
    }

    public Date getNextFireDate() {
        if (this._nextFireDate != null && this._nextFireDate.getTime() > System.currentTimeMillis()) {
            return this._nextFireDate;
        }
        this._nextFireDate = DispatchTriggerLocalServiceUtil.fetchNextFireDate((long)this.getDispatchTriggerId());
        return this._nextFireDate;
    }

    public Date getTimeZoneEndDate() {
        return this._getTimeZoneDate(this.getEndDate(), this.getTimeZoneId());
    }

    public Date getTimeZoneStartDate() {
        return this._getTimeZoneDate(this.getStartDate(), this.getTimeZoneId());
    }

    @Override
    public void setDispatchTaskSettings(String dispatchTaskSettings) {
        super.setDispatchTaskSettings(dispatchTaskSettings);
        this._dispatchTaskSettingsUnicodeProperties = null;
    }

    public void setDispatchTaskSettingsUnicodeProperties(UnicodeProperties dispatchTaskSettingsUnicodeProperties) {
        this._dispatchTaskSettingsUnicodeProperties = dispatchTaskSettingsUnicodeProperties;
        if (this._dispatchTaskSettingsUnicodeProperties == null) {
            this._dispatchTaskSettingsUnicodeProperties = new UnicodeProperties();
        }
        super.setDispatchTaskSettings(this._dispatchTaskSettingsUnicodeProperties.toString());
    }

    private Date _getTimeZoneDate(Date date, String timeZoneId) {
        if (date == null) {
            return null;
        }
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
        return new Date(date.getTime() + (long)timeZone.getOffset(date.getTime()));
    }
}

