/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.executor;

import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutorRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={DispatchTaskExecutorRegistry.class})
public class DispatchTaskExecutorRegistryImpl
implements DispatchTaskExecutorRegistry {
    private static final String _KEY_DISPATCH_TASK_EXECUTOR_TYPE = "dispatch.task.executor.type";
    private static final String _KEY_DISPATCH_TASK_FEATURE_FLAG = "dispatch.task.executor.feature.flag";
    private ServiceTrackerMap<String, DispatchTaskExecutor> _serviceTrackerMap;

    public DispatchTaskExecutor fetchDispatchTaskExecutor(String dispatchTaskExecutorType) {
        return (DispatchTaskExecutor)this._serviceTrackerMap.getService((Object)dispatchTaskExecutorType);
    }

    public String fetchDispatchTaskExecutorName(String dispatchTaskExecutorType) {
        DispatchTaskExecutor dispatchTaskExecutor = this.fetchDispatchTaskExecutor(dispatchTaskExecutorType);
        if (dispatchTaskExecutor != null && !dispatchTaskExecutor.isHiddenInUI()) {
            return dispatchTaskExecutor.getName();
        }
        return null;
    }

    public Set<String> getDispatchTaskExecutorTypes() {
        return this._serviceTrackerMap.keySet();
    }

    public boolean isClusterModeSingle(String type) {
        DispatchTaskExecutor dispatchTaskExecutor = this.fetchDispatchTaskExecutor(type);
        if (dispatchTaskExecutor != null) {
            return dispatchTaskExecutor.isClusterModeSingle();
        }
        return false;
    }

    public boolean isHiddenInUI(String type) {
        DispatchTaskExecutor dispatchTaskExecutor = this.fetchDispatchTaskExecutor(type);
        if (dispatchTaskExecutor != null) {
            return dispatchTaskExecutor.isHiddenInUI();
        }
        return false;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DispatchTaskExecutor.class, null, (serviceReference, emitter) -> {
            String dispatchTaskFeatureFlagKey = (String)serviceReference.getProperty(_KEY_DISPATCH_TASK_FEATURE_FLAG);
            if (Validator.isNull((String)dispatchTaskFeatureFlagKey) || FeatureFlagManagerUtil.isEnabled((String)dispatchTaskFeatureFlagKey)) {
                emitter.emit((Object)((String)serviceReference.getProperty(_KEY_DISPATCH_TASK_EXECUTOR_TYPE)));
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

