/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.metadata;

import com.liferay.dispatch.metadata.DispatchTriggerMetadata;
import com.liferay.dispatch.metadata.DispatchTriggerMetadataFactory;
import com.liferay.dispatch.metadata.DispatchTriggerMetadataProvider;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.DispatchTriggerLocalService;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import java.util.Collections;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DispatchTriggerMetadataProvider.class})
public class DispatchTriggerMetadataProviderImpl
implements DispatchTriggerMetadataProvider {
    private static final String _KEY_DISPATCH_TASK_EXECUTOR_TYPE = "dispatch.task.executor.type";
    private static final DispatchTriggerMetadata _defaultDispatchTriggerMetadata = new DispatchTriggerMetadata(){

        public Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }

        public Map<String, String> getErrors() {
            return Collections.emptyMap();
        }

        public boolean isDispatchTaskExecutorReady() {
            return true;
        }
    };
    @Reference
    private DispatchTriggerLocalService _dispatchTriggerLocalService;
    private ServiceTrackerMap<String, DispatchTriggerMetadataFactory> _serviceTrackerMap;

    public DispatchTriggerMetadata getDispatchTriggerMetadata(long dispatchTriggerId) {
        DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.fetchDispatchTrigger(dispatchTriggerId);
        if (dispatchTrigger == null || !this._serviceTrackerMap.containsKey((Object)dispatchTrigger.getDispatchTaskExecutorType())) {
            return _defaultDispatchTriggerMetadata;
        }
        DispatchTriggerMetadataFactory dispatchTriggerMetadataFactory = (DispatchTriggerMetadataFactory)this._serviceTrackerMap.getService((Object)dispatchTrigger.getDispatchTaskExecutorType());
        return dispatchTriggerMetadataFactory.instance(dispatchTrigger);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DispatchTriggerMetadataFactory.class, null, (serviceReference, emitter) -> emitter.emit((Object)((String)serviceReference.getProperty(_KEY_DISPATCH_TASK_EXECUTOR_TYPE))));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

