/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.verify;

import com.liferay.data.cleanup.internal.verify.PostUpgradeDataCleanupProcess;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.db.DBResourceUtil;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ServiceComponent;
import com.liferay.portal.kernel.module.util.BundleUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.ServiceComponentLocalService;
import com.liferay.portal.kernel.upgrade.data.cleanup.util.DataCleanupLoggingUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.net.URL;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ServiceComponentPostUpgradeDataCleanupProcess
implements PostUpgradeDataCleanupProcess {
    private static final Log _log = LogFactoryUtil.getLog(ServiceComponentPostUpgradeDataCleanupProcess.class);
    private final Connection _connection;
    private final ServiceComponentLocalService _serviceComponentLocalService;

    public ServiceComponentPostUpgradeDataCleanupProcess(Connection connection, ServiceComponentLocalService serviceComponentLocalService) {
        this._connection = connection;
        this._serviceComponentLocalService = serviceComponentLocalService;
    }

    @Override
    public void cleanUp() throws Exception {
        DBInspector dbInspector = new DBInspector(this._connection);
        HashSet latestServiceComponents = new HashSet(this._serviceComponentLocalService.getLatestServiceComponents());
        List serviceComponents = this._serviceComponentLocalService.getServiceComponents(-1, -1);
        String tableName = dbInspector.normalizeName("ServiceComponent");
        for (ServiceComponent serviceComponent : serviceComponents) {
            Properties properties;
            String buildNumberServiceProperties;
            String buildNamespace = serviceComponent.getBuildNamespace();
            if (!buildNamespace.contains(".") && !buildNamespace.equals("portal")) {
                this._serviceComponentLocalService.deleteServiceComponent(serviceComponent);
                DataCleanupLoggingUtil.logDelete((Log)_log, (long)1L, (String)tableName, (String)(buildNamespace + " is not a fully qualified name"));
                continue;
            }
            if (!buildNamespace.startsWith("com.liferay.")) continue;
            Bundle bundle = BundleUtil.getBundle((BundleContext)SystemBundleUtil.getBundleContext(), (String)buildNamespace);
            if (bundle == null) {
                this._serviceComponentLocalService.deleteServiceComponent(serviceComponent);
                DataCleanupLoggingUtil.logDelete((Log)_log, (long)1L, (String)tableName, (String)(buildNamespace + " does not match with any existing bundle"));
                continue;
            }
            if (!latestServiceComponents.contains(serviceComponent) || StringUtil.equals((String)(buildNumberServiceProperties = (properties = PropertiesUtil.load((URL)bundle.getResource("service.properties"))).getProperty("build.number")), (String)String.valueOf(serviceComponent.getBuildNumber())) && Objects.equals(serviceComponent.getData(), this._generateXML(bundle))) continue;
            _log.error((Object)StringBundler.concat((String[])new String[]{"Content of table ", tableName, " for bundle ", buildNamespace, " is outdated"}));
        }
    }

    private String _generateXML(Bundle bundle) throws Exception {
        Document document = SAXReaderUtil.createDocument((String)"UTF-8");
        Element dataElement = document.addElement("data");
        Element tablesSQLElement = dataElement.addElement("tables-sql");
        tablesSQLElement.addCDATA(DBResourceUtil.getModuleTablesSQL((Bundle)bundle));
        Element sequencesSQLElement = dataElement.addElement("sequences-sql");
        sequencesSQLElement.addCDATA(DBResourceUtil.getModuleSequencesSQL((Bundle)bundle));
        Element indexesSQLElement = dataElement.addElement("indexes-sql");
        indexesSQLElement.addCDATA(DBResourceUtil.getModuleIndexesSQL((Bundle)bundle));
        return document.formattedString();
    }
}

