/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.util.spring.boot3;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.core.OAuth2AccessToken;

@Configuration
public class LiferayOAuth2AccessTokenManager {
    private static final Log _log = LogFactory.getLog(LiferayOAuth2AccessTokenManager.class);
    @Autowired
    private AuthorizedClientServiceOAuth2AuthorizedClientManager _authorizedClientServiceOAuth2AuthorizedClientManager;
    private final Map<String, OAuth2AccessToken> _oAuth2AccessTokens = new HashMap<String, OAuth2AccessToken>();

    public String getAuthorization(String externalReferenceCode) {
        OAuth2AccessToken oAuth2AccessToken = this.getOAuth2AccessToken(externalReferenceCode);
        if (oAuth2AccessToken == null) {
            return null;
        }
        return this.getTokenType(externalReferenceCode) + " " + this.getTokenValue(externalReferenceCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth2AccessToken getOAuth2AccessToken(String externalReferenceCode) {
        Map<String, OAuth2AccessToken> map = this._oAuth2AccessTokens;
        synchronized (map) {
            OAuth2AccessToken oAuth2AccessToken = this._oAuth2AccessTokens.get(externalReferenceCode);
            if (oAuth2AccessToken == null) {
                oAuth2AccessToken = this._getOAuth2AccessToken(externalReferenceCode);
                this._oAuth2AccessTokens.put(externalReferenceCode, oAuth2AccessToken);
                return oAuth2AccessToken;
            }
            Instant instant = Instant.now();
            Instant expiresAtInstant = oAuth2AccessToken.getExpiresAt();
            if (expiresAtInstant == null || expiresAtInstant.isBefore(instant.plusSeconds(60L))) {
                oAuth2AccessToken = this._getOAuth2AccessToken(externalReferenceCode);
                this._oAuth2AccessTokens.put(externalReferenceCode, oAuth2AccessToken);
            }
            return oAuth2AccessToken;
        }
    }

    public String getTokenType(String externalReferenceCode) {
        OAuth2AccessToken oAuth2AccessToken = this.getOAuth2AccessToken(externalReferenceCode);
        if (oAuth2AccessToken == null) {
            return null;
        }
        OAuth2AccessToken.TokenType tokenType = oAuth2AccessToken.getTokenType();
        if (tokenType == null) {
            return null;
        }
        return tokenType.getValue();
    }

    public String getTokenValue(String externalReferenceCode) {
        OAuth2AccessToken oAuth2AccessToken = this.getOAuth2AccessToken(externalReferenceCode);
        if (oAuth2AccessToken == null) {
            return null;
        }
        return oAuth2AccessToken.getTokenValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String externalReferenceCode) {
        Map<String, OAuth2AccessToken> map = this._oAuth2AccessTokens;
        synchronized (map) {
            this._oAuth2AccessTokens.put(externalReferenceCode, this._getOAuth2AccessToken(externalReferenceCode));
        }
    }

    private OAuth2AccessToken _getOAuth2AccessToken(String externalReferenceCode) {
        OAuth2AuthorizeRequest.Builder oAuth2AuthorizeRequestBuilder = OAuth2AuthorizeRequest.withClientRegistrationId((String)externalReferenceCode).principal(externalReferenceCode);
        OAuth2AuthorizedClient oAuth2AuthorizedClient = this._authorizedClientServiceOAuth2AuthorizedClientManager.authorize(oAuth2AuthorizeRequestBuilder.build());
        if (oAuth2AuthorizedClient == null) {
            _log.error((Object)"Unable to get OAuth 2 authorized client");
            return null;
        }
        OAuth2AccessToken oAuth2AccessToken = oAuth2AuthorizedClient.getAccessToken();
        if (oAuth2AccessToken == null) {
            _log.error((Object)"Unable to get OAuth 2 access token");
            return null;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Updated OAuth2 access token at " + oAuth2AccessToken.getIssuedAt()));
        }
        return oAuth2AccessToken;
    }
}

