/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.changeset.service.impl;

import com.liferay.changeset.exception.NoSuchCollectionException;
import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.service.ChangesetEntryLocalService;
import com.liferay.changeset.service.base.ChangesetCollectionLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.changeset.model.ChangesetCollection"}, service={AopService.class})
public class ChangesetCollectionLocalServiceImpl
extends ChangesetCollectionLocalServiceBaseImpl {
    @Reference
    private ChangesetEntryLocalService _changesetEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public ChangesetCollection addChangesetCollection(long userId, long groupId, String name, String description) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long changesetCollectionId = this.counterLocalService.increment();
        ChangesetCollection changesetCollection = this.changesetCollectionPersistence.create(changesetCollectionId);
        changesetCollection.setGroupId(groupId);
        changesetCollection.setCompanyId(user.getCompanyId());
        changesetCollection.setUserId(user.getUserId());
        changesetCollection.setUserName(user.getFullName());
        changesetCollection.setName(name);
        changesetCollection.setDescription(description);
        return (ChangesetCollection)this.changesetCollectionPersistence.update((BaseModel)changesetCollection);
    }

    @Override
    public ChangesetCollection deleteChangesetCollection(long changesetCollectionId) throws PortalException {
        this._changesetEntryLocalService.deleteChangesetEntries(changesetCollectionId);
        return super.deleteChangesetCollection(changesetCollectionId);
    }

    public ChangesetCollection fetchChangesetCollection(long groupId, String name) {
        return this.changesetCollectionPersistence.fetchByG_N(groupId, name);
    }

    public ChangesetCollection fetchOrAddChangesetCollection(long groupId, String name) throws PortalException {
        ChangesetCollection changesetCollection = this.changesetCollectionLocalService.fetchChangesetCollection(groupId, name);
        if (changesetCollection != null) {
            return changesetCollection;
        }
        Group group = this._groupLocalService.getGroup(groupId);
        User user = this._userLocalService.getGuestUser(group.getCompanyId());
        return this.changesetCollectionLocalService.addChangesetCollection(user.getUserId(), groupId, name, "");
    }

    public ChangesetCollection getChangesetCollection(long groupId, String name) throws NoSuchCollectionException {
        return this.changesetCollectionPersistence.findByG_N(groupId, name);
    }
}

