/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.changeset.service.impl;

import com.liferay.changeset.exception.NoSuchCollectionException;
import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.service.base.ChangesetCollectionLocalServiceBaseImpl;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;

/**
 * @author Brian Wing Shun Chan
 */
public class ChangesetCollectionLocalServiceImpl
	extends ChangesetCollectionLocalServiceBaseImpl {

	@Override
	public ChangesetCollection addChangesetCollection(
			long userId, long groupId, String name, String description)
		throws PortalException {

		User user = userLocalService.getUser(userId);

		long changesetCollectionId = counterLocalService.increment();

		ChangesetCollection changesetCollection =
			changesetCollectionPersistence.create(changesetCollectionId);

		changesetCollection.setGroupId(groupId);
		changesetCollection.setCompanyId(user.getCompanyId());
		changesetCollection.setUserId(user.getUserId());
		changesetCollection.setUserName(user.getFullName());
		changesetCollection.setName(name);
		changesetCollection.setDescription(description);

		return changesetCollectionPersistence.update(changesetCollection);
	}

	@Override
	public ChangesetCollection deleteChangesetCollection(
			long changesetCollectionId)
		throws PortalException {

		changesetEntryLocalService.deleteChangesetEntries(
			changesetCollectionId);

		return super.deleteChangesetCollection(changesetCollectionId);
	}

	@Override
	public ChangesetCollection fetchChangesetCollection(
		long groupId, String name) {

		return changesetCollectionPersistence.fetchByG_N(groupId, name);
	}

	@Override
	public ChangesetCollection fetchOrAddChangesetCollection(
			long groupId, String name)
		throws PortalException {

		ChangesetCollection changesetCollection =
			changesetCollectionLocalService.fetchChangesetCollection(
				groupId, name);

		if (changesetCollection != null) {
			return changesetCollection;
		}

		Group group = groupLocalService.getGroup(groupId);

		User user = userLocalService.getDefaultUser(group.getCompanyId());

		return changesetCollectionLocalService.addChangesetCollection(
			user.getUserId(), groupId, name, StringPool.BLANK);
	}

	@Override
	public ChangesetCollection getChangesetCollection(long groupId, String name)
		throws NoSuchCollectionException {

		return changesetCollectionPersistence.findByG_N(groupId, name);
	}

}