/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.persistence.impl;

import com.liferay.change.tracking.exception.NoSuchScoreException;
import com.liferay.change.tracking.model.CTScore;
import com.liferay.change.tracking.model.CTScoreTable;
import com.liferay.change.tracking.model.impl.CTScoreImpl;
import com.liferay.change.tracking.model.impl.CTScoreModelImpl;
import com.liferay.change.tracking.service.persistence.CTScorePersistence;
import com.liferay.change.tracking.service.persistence.CTScoreUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTScorePersistence.class})
public class CTScorePersistenceImpl
extends BasePersistenceImpl<CTScore>
implements CTScorePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CTScoreImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathFetchByCtCollectionId;
    private static final String _FINDER_COLUMN_CTCOLLECTIONID_CTCOLLECTIONID_2 = "ctScore.ctCollectionId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_CTSCORE = "SELECT ctScore FROM CTScore ctScore";
    private static final String _SQL_SELECT_CTSCORE_WHERE = "SELECT ctScore FROM CTScore ctScore WHERE ";
    private static final String _SQL_COUNT_CTSCORE = "SELECT COUNT(ctScore) FROM CTScore ctScore";
    private static final String _SQL_COUNT_CTSCORE_WHERE = "SELECT COUNT(ctScore) FROM CTScore ctScore WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ctScore.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CTScore exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CTScore exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CTScorePersistenceImpl.class);

    public CTScore findByCtCollectionId(long ctCollectionId) throws NoSuchScoreException {
        CTScore ctScore = this.fetchByCtCollectionId(ctCollectionId);
        if (ctScore == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("ctCollectionId=");
            sb.append(ctCollectionId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchScoreException(sb.toString());
        }
        return ctScore;
    }

    public CTScore fetchByCtCollectionId(long ctCollectionId) {
        return this.fetchByCtCollectionId(ctCollectionId, true);
    }

    public CTScore fetchByCtCollectionId(long ctCollectionId, boolean useFinderCache) {
        CTScore ctScore;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{ctCollectionId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByCtCollectionId, finderArgs, (BasePersistence)this);
        }
        if (result instanceof CTScore && ctCollectionId != (ctScore = (CTScore)result).getCtCollectionId()) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_CTSCORE_WHERE);
            sb.append(_FINDER_COLUMN_CTCOLLECTIONID_CTCOLLECTIONID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(ctCollectionId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByCtCollectionId, finderArgs, (Object)list);
                    }
                } else {
                    CTScore ctScore2 = (CTScore)list.get(0);
                    result = ctScore2;
                    this.cacheResult(ctScore2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CTScore)result;
    }

    public CTScore removeByCtCollectionId(long ctCollectionId) throws NoSuchScoreException {
        CTScore ctScore = this.findByCtCollectionId(ctCollectionId);
        return (CTScore)this.remove((BaseModel)ctScore);
    }

    public int countByCtCollectionId(long ctCollectionId) {
        CTScore ctScore = this.fetchByCtCollectionId(ctCollectionId);
        if (ctScore == null) {
            return 0;
        }
        return 1;
    }

    public CTScorePersistenceImpl() {
        this.setModelClass(CTScore.class);
        this.setModelImplClass(CTScoreImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CTScoreTable.INSTANCE);
    }

    public void cacheResult(CTScore ctScore) {
        this.entityCache.putResult(CTScoreImpl.class, (Serializable)Long.valueOf(ctScore.getPrimaryKey()), (Serializable)ctScore);
        this.finderCache.putResult(this._finderPathFetchByCtCollectionId, new Object[]{ctScore.getCtCollectionId()}, (Object)ctScore);
    }

    public void cacheResult(List<CTScore> ctScores) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && ctScores.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (CTScore ctScore : ctScores) {
            if (this.entityCache.getResult(CTScoreImpl.class, (Serializable)Long.valueOf(ctScore.getPrimaryKey())) != null) continue;
            this.cacheResult(ctScore);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CTScoreImpl.class);
        this.finderCache.clearCache(CTScoreImpl.class);
    }

    public void clearCache(CTScore ctScore) {
        this.entityCache.removeResult(CTScoreImpl.class, (BaseModel)ctScore);
    }

    public void clearCache(List<CTScore> ctScores) {
        for (CTScore ctScore : ctScores) {
            this.entityCache.removeResult(CTScoreImpl.class, (BaseModel)ctScore);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(CTScoreImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CTScoreImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CTScoreModelImpl ctScoreModelImpl) {
        Object[] args = new Object[]{ctScoreModelImpl.getCtCollectionId()};
        this.finderCache.putResult(this._finderPathFetchByCtCollectionId, args, (Object)ctScoreModelImpl);
    }

    public CTScore create(long ctScoreId) {
        CTScoreImpl ctScore = new CTScoreImpl();
        ctScore.setNew(true);
        ctScore.setPrimaryKey(ctScoreId);
        ctScore.setCompanyId(CompanyThreadLocal.getCompanyId());
        return ctScore;
    }

    public CTScore remove(long ctScoreId) throws NoSuchScoreException {
        return this.remove(Long.valueOf(ctScoreId));
    }

    public CTScore remove(Serializable primaryKey) throws NoSuchScoreException {
        Session session = null;
        try {
            session = this.openSession();
            CTScore ctScore = (CTScore)session.get(CTScoreImpl.class, primaryKey);
            if (ctScore == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchScoreException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CTScore cTScore = (CTScore)this.remove((BaseModel)ctScore);
            return cTScore;
        }
        catch (NoSuchScoreException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTScore removeImpl(CTScore ctScore) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ctScore)) {
                ctScore = (CTScore)session.get(CTScoreImpl.class, ctScore.getPrimaryKeyObj());
            }
            if (ctScore != null) {
                session.delete((Object)ctScore);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ctScore != null) {
            this.clearCache(ctScore);
        }
        return ctScore;
    }

    public CTScore updateImpl(CTScore ctScore) {
        boolean isNew = ctScore.isNew();
        if (!(ctScore instanceof CTScoreModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ctScore.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ctScore);
                throw new IllegalArgumentException("Implement ModelWrapper in ctScore proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CTScore implementation " + ctScore.getClass());
        }
        CTScoreModelImpl ctScoreModelImpl = (CTScoreModelImpl)ctScore;
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)ctScore);
            } else {
                ctScore = (CTScore)session.merge((Object)ctScore);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CTScoreImpl.class, (BaseModel)ctScoreModelImpl, false, true);
        this.cacheUniqueFindersCache(ctScoreModelImpl);
        if (isNew) {
            ctScore.setNew(false);
        }
        ctScore.resetOriginalValues();
        return ctScore;
    }

    public CTScore findByPrimaryKey(Serializable primaryKey) throws NoSuchScoreException {
        CTScore ctScore = (CTScore)this.fetchByPrimaryKey(primaryKey);
        if (ctScore == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchScoreException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ctScore;
    }

    public CTScore findByPrimaryKey(long ctScoreId) throws NoSuchScoreException {
        return this.findByPrimaryKey(Long.valueOf(ctScoreId));
    }

    public CTScore fetchByPrimaryKey(long ctScoreId) {
        return (CTScore)this.fetchByPrimaryKey(Long.valueOf(ctScoreId));
    }

    public List<CTScore> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CTScore> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CTScore> findAll(int start, int end, OrderByComparator<CTScore> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CTScore> findAll(int start, int end, OrderByComparator<CTScore> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_CTSCORE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_CTSCORE;
                sql = sql.concat(" ORDER BY ctScore.ctScoreId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CTScore ctScore : this.findAll()) {
            this.remove((BaseModel)ctScore);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_CTSCORE);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "ctScoreId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_CTSCORE;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CTScoreModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathFetchByCtCollectionId = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByCtCollectionId", new String[]{Long.class.getName()}, new String[]{"ctCollectionId"}, true);
        CTScoreUtil.setPersistence((CTScorePersistence)this);
    }

    @Deactivate
    public void deactivate() {
        CTScoreUtil.setPersistence(null);
        this.entityCache.removeCache(CTScoreImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.change.tracking.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.change.tracking.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.change.tracking.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

