/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.model.CTRemote;
import com.liferay.change.tracking.model.CTRemoteTable;
import com.liferay.change.tracking.service.base.CTRemoteServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ct", "json.web.service.context.path=CTRemote"}, service={AopService.class})
public class CTRemoteServiceImpl
extends CTRemoteServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.change.tracking.model.CTRemote)")
    private ModelResourcePermission<CTRemote> _ctRemoteModelResourcePermission;
    @Reference
    private CustomSQL _customSQL;
    @Reference(target="(resource.name=com.liferay.change.tracking)")
    private PortletResourcePermission _portletResourcePermission;

    public CTRemote addCTRemote(String name, String description, String url, String clientId, String clientSecret) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_REMOTE");
        return this.ctRemoteLocalService.addCTRemote(this.getUserId(), name, description, url, clientId, clientSecret);
    }

    public CTRemote deleteCTRemote(CTRemote ctRemote) throws PortalException {
        this._ctRemoteModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ctRemote, "DELETE");
        return this.ctRemoteLocalService.deleteCTRemote(ctRemote);
    }

    public CTRemote deleteCTRemote(long ctRemoteId) throws PortalException {
        this._ctRemoteModelResourcePermission.check(this.getPermissionChecker(), ctRemoteId, "DELETE");
        return this.ctRemoteLocalService.deleteCTRemote(ctRemoteId);
    }

    public List<CTRemote> getCTRemotes(String keywords, int start, int end, OrderByComparator<CTRemote> orderByComparator) {
        String[] keywordsArray = this._customSQL.keywords(keywords, true, WildcardMode.SURROUND);
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Table)CTRemoteTable.INSTANCE).from((Table)CTRemoteTable.INSTANCE).where(CTRemoteTable.INSTANCE.companyId.eq((Object)CompanyThreadLocal.getCompanyId()).and((Expression)Predicate.or((Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)CTCollectionTable.INSTANCE.name), keywordsArray), (Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)CTCollectionTable.INSTANCE.description), keywordsArray)))).orderBy((Table)CTRemoteTable.INSTANCE, orderByComparator).limit(start, end);
        return (List)this.ctRemotePersistence.dslQuery(dslQuery);
    }

    public int getCTRemotesCount(String keywords) {
        String[] keywordsArray = this._customSQL.keywords(keywords, true, WildcardMode.SURROUND);
        GroupByStep dslQuery = DSLQueryFactoryUtil.count().from((Table)CTRemoteTable.INSTANCE).where(CTRemoteTable.INSTANCE.companyId.eq((Object)CompanyThreadLocal.getCompanyId()).and((Expression)Predicate.or((Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)CTCollectionTable.INSTANCE.name), keywordsArray), (Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)CTCollectionTable.INSTANCE.description), keywordsArray))));
        return this.ctRemotePersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    public CTRemote updateCTRemote(long ctRemoteId, String name, String description, String url, String clientId, String clientSecret) throws PortalException {
        this._ctRemoteModelResourcePermission.check(this.getPermissionChecker(), ctRemoteId, "UPDATE");
        return this.ctRemoteLocalService.updateCTRemote(ctRemoteId, name, description, url, clientId, clientSecret);
    }
}

