/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.internal.background.task.CTPublishBackgroundTaskExecutor;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.change.tracking.service.base.CTProcessLocalServiceBaseImpl;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.change.tracking.model.CTProcess"}, service={AopService.class})
public class CTProcessLocalServiceImpl
extends CTProcessLocalServiceBaseImpl {
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CTProcess addCTProcess(long userId, long ctCollectionId) throws PortalException {
        CTCollection ctCollection = this._ctCollectionLocalService.getCTCollection(ctCollectionId);
        if (ctCollection.getStatus() == 0) {
            throw new IllegalStateException("Change tracking collection is already published " + ctCollection);
        }
        if (ctCollection.isEmpty()) {
            throw new IllegalStateException("Change tracking collection is empty " + ctCollection);
        }
        ctCollection.setStatus(1);
        ctCollection = this._ctCollectionLocalService.updateCTCollection(ctCollection);
        if (!FeatureFlagManagerUtil.isEnabled((long)ctCollection.getCompanyId(), (String)"LPD-39203")) {
            this._ctPreferencesLocalService.resetCTPreferences(ctCollection.getCtCollectionId());
        }
        long ctProcessId = this.counterLocalService.increment(CTProcess.class.getName());
        CTProcess ctProcess = this.ctProcessPersistence.create(ctProcessId);
        ctProcess.setCompanyId(ctCollection.getCompanyId());
        ctProcess.setUserId(userId);
        ctProcess.setCreateDate(new Date());
        ctProcess.setCtCollectionId(ctCollectionId);
        Company company = this._companyLocalService.getCompany(ctCollection.getCompanyId());
        HashMap taskContextMap = HashMapBuilder.put((Object)"ctCollectionId", (Object)ctCollectionId).put((Object)"ctProcessId", (Object)ctProcessId).build();
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
            BackgroundTask backgroundTask = this._backgroundTaskLocalService.addBackgroundTask(userId, company.getGroupId(), String.valueOf(ctCollectionId), null, CTPublishBackgroundTaskExecutor.class, (Map)taskContextMap, null);
            ctProcess.setBackgroundTaskId(backgroundTask.getBackgroundTaskId());
        }
        ctProcess = (CTProcess)this.ctProcessPersistence.update((BaseModel)ctProcess);
        this._resourceLocalService.addResources(ctProcess.getCompanyId(), 0L, ctProcess.getUserId(), CTProcess.class.getName(), ctProcess.getCtProcessId(), false, false, false);
        return ctProcess;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CTProcess deleteCTProcess(CTProcess ctProcess) throws PortalException {
        this.ctProcessPersistence.remove((BaseModel)ctProcess);
        this._resourceLocalService.deleteResource(ctProcess.getCompanyId(), CTProcess.class.getName(), 4, ctProcess.getCtProcessId());
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.fetchBackgroundTask(ctProcess.getBackgroundTaskId());
        if (backgroundTask != null) {
            CTCollection ctCollection;
            if (backgroundTask.getStatus() == 3 && (ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctProcess.getCtCollectionId())) != null) {
                this._ctCollectionLocalService.deleteCTCollection(ctCollection);
            }
            this._backgroundTaskLocalService.deleteBackgroundTask(backgroundTask);
        }
        return ctProcess;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CTProcess deleteCTProcess(long ctProcessId) throws PortalException {
        CTProcess ctProcess = this.ctProcessPersistence.findByPrimaryKey(ctProcessId);
        return this.deleteCTProcess(ctProcess);
    }

    public CTProcess fetchLatestCTProcess(long companyId) {
        return this.ctProcessPersistence.fetchByCompanyId_First(companyId, null);
    }

    public List<CTProcess> getCTProcesses(long ctCollectionId) {
        return this.ctProcessPersistence.findByCtCollectionId(ctCollectionId);
    }
}

