/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.PortletPreferenceValue;
import com.liferay.portal.kernel.service.PortletPreferenceValueLocalService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConstraintResolver.class})
public class PortletPreferenceValueConstraintResolver
implements ConstraintResolver<PortletPreferenceValue> {
    @Reference
    private PortletPreferenceValueLocalService _portletPreferenceValueLocalService;

    public String getConflictDescriptionKey() {
        return "duplicate-widget-preference-value";
    }

    public Class<PortletPreferenceValue> getModelClass() {
        return PortletPreferenceValue.class;
    }

    public String getResolutionDescriptionKey() {
        return "duplicate-widget-preference-value-was-removed";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((Locale)locale, PortletPreferenceValueConstraintResolver.class);
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"portletPreferencesId", "index_", "name"};
    }

    public void resolveConflict(ConstraintResolverContext<PortletPreferenceValue> constraintResolverContext) throws PortalException {
        PortletPreferenceValue sourcePortletPreferenceValue = (PortletPreferenceValue)constraintResolverContext.getSourceCTModel();
        this._portletPreferenceValueLocalService.deletePortletPreferenceValue(sourcePortletPreferenceValue);
        CTPersistence ctPersistence = this._portletPreferenceValueLocalService.getCTPersistence();
        ctPersistence.flush();
        PortletPreferenceValue targetPortletPreferenceValue = (PortletPreferenceValue)constraintResolverContext.getTargetCTModel();
        targetPortletPreferenceValue.setReadOnly(sourcePortletPreferenceValue.isReadOnly());
        targetPortletPreferenceValue.setValue(sourcePortletPreferenceValue.getValue());
        this._portletPreferenceValueLocalService.updatePortletPreferenceValue(targetPortletPreferenceValue);
    }
}

