/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.spi.listener;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.spi.exception.CTEventException;
import com.liferay.change.tracking.spi.listener.CTEventListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.TicketLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTEventListener.class})
public class CTOnDemandUserEventListener
implements CTEventListener {
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private TicketLocalService _ticketLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterPublish(long ctCollectionId) throws CTEventException {
        CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctCollectionId);
        if (ctCollection.getOnDemandUserId() <= 0L) {
            return;
        }
        this._deleteOnDemandUser(ctCollection);
    }

    public void onBeforeRemove(long ctCollectionId) throws CTEventException {
        CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctCollectionId);
        if (ctCollection == null || ctCollection.getOnDemandUserId() <= 0L) {
            return;
        }
        this._deleteOnDemandUser(ctCollection);
    }

    private void _deleteOnDemandUser(CTCollection ctCollection) throws CTEventException {
        try {
            for (Ticket ticket : this._ticketLocalService.getTickets(ctCollection.getCompanyId(), CTCollection.class.getName(), ctCollection.getCtCollectionId(), 5)) {
                this._ticketLocalService.deleteTicket(ticket);
            }
            User user = this._userLocalService.fetchUser(ctCollection.getOnDemandUserId());
            if (user != null) {
                this._userLocalService.deleteUser(user);
            }
            ctCollection.setOnDemandUserId(0L);
            this._ctCollectionLocalService.updateCTCollection(ctCollection);
        }
        catch (PortalException portalException) {
            throw new CTEventException((Throwable)portalException);
        }
    }
}

