/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.security.permission.resource;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTemplate;
import com.liferay.change.tracking.service.CTCollectionTemplateLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.change.tracking.model.CTCollectionTemplate"}, service={ModelResourcePermission.class})
public class CTCollectionTemplateModelResourcePermission
implements ModelResourcePermission<CTCollectionTemplate> {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTCollectionTemplateLocalService _ctCollectionTemplateLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(resource.name=com.liferay.change.tracking)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, CTCollectionTemplate ctCollectionTemplate, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, ctCollectionTemplate, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CTCollectionTemplate.class.getName(), ctCollectionTemplate.getCtCollectionTemplateId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long ctCollectionTemplateId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, ctCollectionTemplateId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CTCollectionTemplate.class.getName(), ctCollectionTemplateId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CTCollectionTemplate ctCollectionTemplate, String actionId) {
        if (permissionChecker.hasOwnerPermission(ctCollectionTemplate.getCompanyId(), CTCollectionTemplate.class.getName(), ctCollectionTemplate.getCtCollectionTemplateId(), ctCollectionTemplate.getUserId(), actionId)) {
            return true;
        }
        Group group = this._groupLocalService.fetchGroup(ctCollectionTemplate.getCompanyId(), this._classNameLocalService.getClassNameId(CTCollectionTemplate.class), ctCollectionTemplate.getCtCollectionTemplateId());
        return permissionChecker.hasPermission(group, CTCollectionTemplate.class.getName(), ctCollectionTemplate.getCtCollectionTemplateId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long ctCollectionTemplateId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._ctCollectionTemplateLocalService.getCTCollectionTemplate(ctCollectionTemplateId), actionId);
    }

    public String getModelName() {
        return CTCollection.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

