/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.search.spi.model.index.contributor;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.change.tracking.model.CTProcess"}, service={ModelDocumentContributor.class})
public class CTProcessModelDocumentContributor
implements ModelDocumentContributor<CTProcess> {
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void contribute(Document document, CTProcess ctProcess) {
        BackgroundTask backgroundTask;
        document.addKeyword("companyId", ctProcess.getCompanyId());
        document.addDate("createDate", ctProcess.getCreateDate());
        CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctProcess.getCtCollectionId());
        if (ctCollection != null) {
            document.addText("description", ctCollection.getDescription());
            document.addText("name", ctCollection.getName());
        }
        if ((backgroundTask = this._backgroundTaskLocalService.fetchBackgroundTask(ctProcess.getBackgroundTaskId())) != null) {
            document.addKeyword("status", backgroundTask.getStatus());
        }
        document.addKeyword("type", ctProcess.getType());
        User user = this._userLocalService.fetchUser(ctProcess.getUserId());
        if (user != null) {
            document.addKeyword("userId", user.getUserId());
            document.addText("userName", user.getFullName());
        } else {
            document.addKeyword("userId", ctProcess.getUserId());
        }
    }
}

