/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.dispatch.executor;

import com.liferay.change.tracking.internal.helper.CTUserNotificationHelper;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.dispatch.executor.BaseDispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutorOutput;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dispatch.task.executor.name=scheduled-publications-conflict-checks", "dispatch.task.executor.type=scheduled-publications-conflict-checks"}, service={DispatchTaskExecutor.class})
public class CTConflictCheckerDispatchTaskExecutor
extends BaseDispatchTaskExecutor {
    public static final String KEY = "scheduled-publications-conflict-checks";
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTUserNotificationHelper _publicationRoleUserHelper;

    public void doExecute(DispatchTrigger dispatchTrigger, DispatchTaskExecutorOutput dispatchTaskExecutorOutput) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._ctCollectionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"status", (Object)7)));
        actionableDynamicQuery.setCompanyId(dispatchTrigger.getCompanyId());
        actionableDynamicQuery.setPerformActionMethod(ctCollection -> {
            Map conflictMap = this._ctCollectionLocalService.checkConflicts(ctCollection);
            if (conflictMap.isEmpty()) {
                return;
            }
            this._publicationRoleUserHelper.sendUserNotificationEvents((CTCollection)ctCollection, JSONUtil.put((String)"ctCollectionId", (Object)ctCollection.getCtCollectionId()).put("ctCollectionName", HtmlUtil.escape((String)ctCollection.getName())).put("notificationType", 2).put("scheduled", true).put("showConflicts", true), this._publicationRoleUserHelper.getPublicationRoleUserIds((CTCollection)ctCollection, true, "com_liferay_change_tracking_web_portlet_PublicationsPortlet.admin", "com_liferay_change_tracking_web_portlet_PublicationsPortlet.editor", "com_liferay_change_tracking_web_portlet_PublicationsPortlet.publisher"));
        });
        actionableDynamicQuery.performActions();
    }

    public String getName() {
        return KEY;
    }

    public boolean isHiddenInUI() {
        return true;
    }
}

