/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.closure.CTClosureFactory;
import com.liferay.change.tracking.internal.CTServiceRegistry;
import com.liferay.change.tracking.model.CTAutoResolutionInfo;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.service.CTProcessLocalService;
import com.liferay.change.tracking.service.base.CTCollectionServiceBaseImpl;
import com.liferay.change.tracking.service.persistence.CTAutoResolutionInfoPersistence;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ct", "json.web.service.context.path=CTCollection"}, service={AopService.class})
public class CTCollectionServiceImpl
extends CTCollectionServiceBaseImpl {
    @Reference
    private CTAutoResolutionInfoPersistence _ctAutoResolutionInfoPersistence;
    @Reference
    private CTClosureFactory _ctClosureFactory;
    @Reference(target="(model.class.name=com.liferay.change.tracking.model.CTCollection)")
    private ModelResourcePermission<CTCollection> _ctCollectionModelResourcePermission;
    @Reference
    private CTProcessLocalService _ctProcessLocalService;
    @Reference
    private CTServiceRegistry _ctServiceRegistry;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private InlineSQLHelper _inlineSQLHelper;
    @Reference(target="(resource.name=com.liferay.change.tracking)")
    private PortletResourcePermission _portletResourcePermission;

    public CTCollection addCTCollection(long companyId, long userId, String name, String description) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_PUBLICATION");
        return this.ctCollectionLocalService.addCTCollection(companyId, userId, name, description);
    }

    public void deleteCTAutoResolutionInfo(long ctAutoResolutionInfoId) throws PortalException {
        CTAutoResolutionInfo ctAutoResolutionInfo = this._ctAutoResolutionInfoPersistence.fetchByPrimaryKey(ctAutoResolutionInfoId);
        if (ctAutoResolutionInfo == null) {
            return;
        }
        this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), ctAutoResolutionInfo.getCtCollectionId(), "UPDATE");
        this.ctCollectionLocalService.deleteCTAutoResolutionInfo(ctAutoResolutionInfoId);
    }

    public CTCollection deleteCTCollection(CTCollection ctCollection) throws PortalException {
        this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ctCollection, "DELETE");
        return this.ctCollectionLocalService.deleteCTCollection(ctCollection);
    }

    public void discardCTEntries(long ctCollectionId, long modelClassNameId, long modelClassPK) throws PortalException {
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ctCollection, "UPDATE");
        this.ctCollectionLocalService.discardCTEntries(ctCollectionId, modelClassNameId, modelClassPK, false);
    }

    public void discardCTEntry(long ctCollectionId, long modelClassNameId, long modelClassPK) throws PortalException {
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ctCollection, "UPDATE");
        this.ctCollectionLocalService.discardCTEntry(ctCollectionId, modelClassNameId, modelClassPK, false);
    }

    public List<CTCollection> getCTCollections(long companyId, int status, int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        if (status == -1) {
            return this.ctCollectionPersistence.filterFindByCompanyId(companyId, start, end, orderByComparator);
        }
        return this.ctCollectionPersistence.filterFindByC_S(companyId, status, start, end, orderByComparator);
    }

    public List<CTCollection> getCTCollections(long companyId, int status, String keywords, int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Table)CTCollectionTable.INSTANCE).from((Table)CTCollectionTable.INSTANCE).where(this._getPredicate(companyId, status, keywords)).orderBy((Table)CTCollectionTable.INSTANCE, orderByComparator).limit(start, end);
        return (List)this.ctCollectionPersistence.dslQuery(dslQuery);
    }

    public int getCTCollectionsCount(long companyId, int status, String keywords) {
        GroupByStep dslQuery = DSLQueryFactoryUtil.count().from((Table)CTCollectionTable.INSTANCE).where(this._getPredicate(companyId, status, keywords));
        return this.ctCollectionPersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    public void publishCTCollection(long userId, long ctCollectionId) throws PortalException {
        this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), ctCollectionId, "PUBLISH");
        this._ctProcessLocalService.addCTProcess(userId, ctCollectionId);
    }

    public CTCollection undoCTCollection(long ctCollectionId, long userId, String name, String description) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        this._ctCollectionModelResourcePermission.check(permissionChecker, ctCollectionId, "VIEW");
        this._portletResourcePermission.check(permissionChecker, null, "ADD_PUBLICATION");
        return this.ctCollectionLocalService.undoCTCollection(ctCollectionId, userId, name, description);
    }

    public CTCollection updateCTCollection(long userId, long ctCollectionId, String name, String description) throws PortalException {
        this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), ctCollectionId, "UPDATE");
        return this.ctCollectionLocalService.updateCTCollection(userId, ctCollectionId, name, description);
    }

    private Predicate _getPredicate(long companyId, int status, String keywords) {
        Predicate predicate = CTCollectionTable.INSTANCE.companyId.eq((Object)companyId);
        if (status != -1) {
            predicate = predicate.and((Expression)CTCollectionTable.INSTANCE.status.eq((Object)status));
        }
        String[] keywordsArray = this._customSQL.keywords(keywords, true, WildcardMode.SURROUND);
        return predicate.and((Expression)Predicate.withParentheses((Predicate)Predicate.or((Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)CTCollectionTable.INSTANCE.name), keywordsArray), (Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)CTCollectionTable.INSTANCE.description), keywordsArray)))).and((Expression)this._inlineSQLHelper.getPermissionWherePredicate(CTCollection.class, CTCollectionTable.INSTANCE.ctCollectionId, new long[0]));
    }
}

