/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.reference;

import com.liferay.change.tracking.internal.reference.TableJoinHolder;
import com.liferay.change.tracking.internal.reference.TableUtil;
import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNode;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.WhereStep;
import com.liferay.petra.sql.dsl.spi.expression.DefaultPredicate;
import com.liferay.petra.sql.dsl.spi.expression.Operand;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.petra.sql.dsl.spi.query.From;
import com.liferay.petra.sql.dsl.spi.query.Join;
import com.liferay.petra.sql.dsl.spi.query.JoinType;
import com.liferay.petra.string.StringBundler;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class TableJoinHolderFactory {
    private static final Consumer<String> _emptyStringConsumer = string -> {};
    private static final FromStep _validationFromStep = new ValidationFromStep();
    private static final Set<Operand> _validOperands = new HashSet<Operand>(){
        {
            this.add(Operand.AND);
            this.add(Operand.EQUAL);
            this.add(Operand.LIKE);
        }
    };

    public static <T extends Table<T>> TableJoinHolder create(Function<FromStep, JoinStep> joinFunction, boolean parent, Column<T, Long> primaryKeyColumn, TableReferenceDefinition<T> tableReferenceDefinition) {
        JoinStep joinStep = joinFunction.apply(_validationFromStep);
        if (!(joinStep instanceof Join)) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Missing join in \"", joinStep, "\""}));
        }
        JoinStepASTNodeListener joinStepASTNodeListener = new JoinStepASTNodeListener(tableReferenceDefinition.getTable(), null);
        joinStep.toSQL(_emptyStringConsumer, joinStepASTNodeListener);
        if (joinStepASTNodeListener._fromTable == null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Join function must use provided from step for join step ", "\"", joinStep, "\""}));
        }
        if (!joinStepASTNodeListener._hasRequiredTable) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Required table \"", tableReferenceDefinition.getTable(), "\" is unused in join step \"", joinStep, "\""}));
        }
        if (joinStepASTNodeListener._invalidJoin != null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Invalid join for join step \"", joinStep, "\", ensure table alias is used for self joins"}));
        }
        if (joinStepASTNodeListener._invalidJoinOrder) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"First join must be on table \"", tableReferenceDefinition.getTable(), "\" for join step \"", joinStep, "\""}));
        }
        if (joinStepASTNodeListener._invalidJoinType != null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Invalid join type \"", joinStepASTNodeListener._invalidJoinType, "\" for join step \"", joinStep, "\""}));
        }
        if (joinStepASTNodeListener._invalidOperand != null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Invalid predicate operand \"", joinStepASTNodeListener._invalidOperand, "\" for join step \"", joinStep, "\""}));
        }
        if (!joinStepASTNodeListener._tables.containsAll(joinStepASTNodeListener._columnTables)) {
            ArrayList<Table> columnTables = new ArrayList<Table>(joinStepASTNodeListener._columnTables);
            Comparator<Table> comparator = Comparator.comparing(Table::getName);
            columnTables.sort(comparator);
            ArrayList<Table> joinTables = new ArrayList<Table>(joinStepASTNodeListener._tables);
            joinTables.sort(comparator);
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Predicate column tables ", columnTables, " do not match join tables ", joinTables, " for join step \"", joinStep, "\""}));
        }
        Column fromPKColumn = TableUtil.getPrimaryKeyColumn(joinStepASTNodeListener._fromTable);
        if (fromPKColumn == null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"No long type primary key column found for table \"", joinStepASTNodeListener._fromTable, "\" for join step \"", joinStep, "\""}));
        }
        JoinStep missingRequirementWhereStep = null;
        Predicate missingRequirementWherePredicate = null;
        if (parent) {
            Table table;
            Table parentTable = fromPKColumn.getTable();
            FromStep fromStep = DSLQueryFactoryUtil.select((Expression[])new Expression[]{primaryKeyColumn, new Scalar((Object)parentTable.getTableName())});
            ArrayList childPredicateColumns = new ArrayList();
            LinkedList<AbstractMap.SimpleImmutableEntry<Table, PredicateASTNodeListener>> joinEntries = new LinkedList<AbstractMap.SimpleImmutableEntry<Table, PredicateASTNodeListener>>();
            ASTNode astNode = (ASTNode)joinFunction.apply(fromStep);
            while (astNode instanceof Join) {
                Join join = (Join)astNode;
                PredicateASTNodeListener predicateASTNodeListener = new PredicateASTNodeListener(primaryKeyColumn.getTable(), childPredicateColumns);
                Predicate predicate = join.getOnPredicate();
                predicate.toSQL(_emptyStringConsumer, (ASTNodeListener)predicateASTNodeListener);
                table = join.getTable();
                if (table == primaryKeyColumn.getTable()) {
                    table = parentTable;
                }
                joinEntries.push(new AbstractMap.SimpleImmutableEntry<Table, PredicateASTNodeListener>(table, predicateASTNodeListener));
                astNode = join.getChild();
            }
            Predicate wherePredicate = fromPKColumn.isNull();
            joinStep = fromStep.from(primaryKeyColumn.getTable());
            for (Map.Entry entry : joinEntries) {
                table = (Table)entry.getKey();
                PredicateASTNodeListener predicateASTNodeListener = (PredicateASTNodeListener)entry.getValue();
                joinStep = joinStep.leftJoinOn(table, predicateASTNodeListener._joinPredicate);
                if (predicateASTNodeListener._wherePredicate == null) continue;
                wherePredicate = wherePredicate.and((Expression)predicateASTNodeListener._wherePredicate);
            }
            missingRequirementWhereStep = joinStep;
            for (Column column : childPredicateColumns) {
                wherePredicate = wherePredicate.and((Expression)column.isNotNull());
                Class clazz = column.getJavaType();
                if (clazz == String.class) {
                    Column stringColumn = column;
                    wherePredicate = wherePredicate.and((Expression)stringColumn.neq((Object)""));
                    continue;
                }
                if (clazz != Long.class) continue;
                Column longColumn = column;
                wherePredicate = wherePredicate.and((Expression)longColumn.neq((Object)0L));
            }
            missingRequirementWherePredicate = wherePredicate;
        }
        return new TableJoinHolder(primaryKeyColumn, joinFunction, missingRequirementWherePredicate, (WhereStep)missingRequirementWhereStep, fromPKColumn);
    }

    private static class ValidationFromStep
    implements FromStep {
        private ValidationFromStep() {
        }

        public Table<?> as(String name) {
            throw new UnsupportedOperationException();
        }

        public JoinStep from(Table<?> table) {
            return new From((FromStep)this, table);
        }

        public void toSQL(Consumer<String> consumer, ASTNodeListener astNodeListener) {
            consumer.accept("...");
        }

        public DSLQuery union(DSLQuery dslQuery) {
            throw new UnsupportedOperationException();
        }

        public DSLQuery unionAll(DSLQuery dslQuery) {
            throw new UnsupportedOperationException();
        }
    }

    private static class PredicateASTNodeListener
    implements ASTNodeListener {
        private final List<Column<?, ?>> _childPredicateColumns;
        private final Table<?> _childTable;
        private Predicate _joinPredicate;
        private Predicate _wherePredicate;

        public void process(ASTNode astNode) {
            if (!(astNode instanceof DefaultPredicate)) {
                return;
            }
            DefaultPredicate defaultPredicate = (DefaultPredicate)astNode;
            if (defaultPredicate.getOperand() == Operand.AND) {
                return;
            }
            Expression leftExpression = defaultPredicate.getLeftExpression();
            Expression rightExpression = defaultPredicate.getRightExpression();
            if (leftExpression instanceof Column && rightExpression instanceof Column) {
                Column leftColumn = (Column)leftExpression;
                Column rightColumn = (Column)rightExpression;
                if (leftColumn.getTable() == this._childTable) {
                    this._childPredicateColumns.add(leftColumn);
                } else if (rightColumn.getTable() == this._childTable) {
                    this._childPredicateColumns.add(rightColumn);
                }
                this._joinPredicate = this._joinPredicate == null ? defaultPredicate : this._joinPredicate.and((Expression)defaultPredicate);
            } else {
                this._wherePredicate = this._wherePredicate == null ? defaultPredicate : this._wherePredicate.and((Expression)defaultPredicate);
            }
        }

        private PredicateASTNodeListener(Table<?> childTable, List<Column<?, ?>> childPredicateColumns) {
            this._childTable = childTable;
            this._childPredicateColumns = childPredicateColumns;
        }
    }

    private static class JoinStepASTNodeListener<T extends Table<T>>
    implements ASTNodeListener {
        private Set<Table<?>> _columnTables = Collections.newSetFromMap(new IdentityHashMap());
        private Table<?> _fromTable;
        private boolean _hasRequiredTable;
        private Join _invalidJoin;
        private boolean _invalidJoinOrder;
        private JoinType _invalidJoinType;
        private Operand _invalidOperand;
        private final T _table;
        private Set<Table<?>> _tables = Collections.newSetFromMap(new IdentityHashMap());

        public void process(ASTNode astNode) {
            if (astNode instanceof Column) {
                Column column = (Column)astNode;
                this._columnTables.add(column.getTable());
                if (!this._hasRequiredTable && Objects.equals(this._table, column.getTable())) {
                    this._hasRequiredTable = true;
                }
            } else if (astNode instanceof DefaultPredicate) {
                DefaultPredicate defaultPredicate = (DefaultPredicate)astNode;
                Operand operand = defaultPredicate.getOperand();
                if (!_validOperands.contains(operand) && this._invalidOperand == null) {
                    this._invalidOperand = operand;
                }
            } else if (astNode instanceof From) {
                From from = (From)astNode;
                if (from.getChild() == _validationFromStep) {
                    this._fromTable = from.getTable();
                    this._tables.add(from.getTable());
                }
            } else if (astNode instanceof Join) {
                Join join = (Join)astNode;
                JoinType joinType = join.getJoinType();
                if (joinType != JoinType.INNER) {
                    this._invalidJoinType = joinType;
                }
                Table table = join.getTable();
                if (this._tables.size() == 1 && table != this._table) {
                    this._invalidJoinOrder = true;
                }
                if (table.equals(this._fromTable) && Objects.equals(this._fromTable.getName(), table.getName())) {
                    this._invalidJoin = join;
                }
                this._tables.add(table);
            }
        }

        private JoinStepASTNodeListener(T table) {
            this._table = table;
        }

        /* synthetic */ JoinStepASTNodeListener(Table x0, 1 x1) {
            this(x0);
        }
    }
}

