/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.editor.configuration.internal;

import com.liferay.blogs.item.selector.BlogsItemSelectorCriterion;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.FileEntryItemSelectorReturnType;
import com.liferay.item.selector.criteria.URLItemSelectorReturnType;
import com.liferay.item.selector.criteria.image.criterion.ImageItemSelectorCriterion;
import com.liferay.item.selector.criteria.url.criterion.URLItemSelectorCriterion;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.editor.configuration.BaseEditorConfigContributor;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.blogs.configuration.BlogsFileUploadsConfiguration"}, property={"editor.config.key=contentEditor", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAdminPortlet"}, service={EditorConfigContributor.class})
public class BlogsContentEditorConfigContributor
extends BaseEditorConfigContributor {
    @Reference
    private ItemSelector _itemSelector;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        String editorName;
        jsonObject.put("allowedContent", StringBundler.concat((String[])new String[]{"a[*](*); ", this._getAllowedContentText(), " div[*](*); figcaption; figure; iframe[*](*); img[*](*){*}; ", this._getAllowedContentLists(), " p[*](*){text-align}; ", this._getAllowedContentTable(), " source[*](*); video[*](*);"})).put("stylesSet", this._getStyleFormatsJSONArray(themeDisplay.getLocale()));
        String namespace = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:namespace"));
        String name = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:name"));
        this._populateFileBrowserURL(jsonObject, requestBackedPortletURLFactory, namespace + name + "selectItem");
        this._populateTwitterButton(jsonObject);
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        if (Validator.isNotNull((String)portletDisplay.getId())) {
            jsonObject.put("uploadUrl", PortletURLBuilder.create((PortletURL)requestBackedPortletURLFactory.createActionURL(portletDisplay.getId())).setActionName("/blogs/upload_temp_image").buildString());
        }
        if ((editorName = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:editorName"))).equals("ballooneditor")) {
            jsonObject.put("extraPlugins", "itemselector,stylescombo,ballooneditor,videoembed,insertbutton,codemirror").put("toolbarText", "Styles,Bold,Italic,Underline,BulletedList,NumberedList,TextLink,SourceEditor");
        }
    }

    private String _getAllowedContentLists() {
        return "li ol ul;";
    }

    private String _getAllowedContentTable() {
        return StringBundler.concat((String[])new String[]{"col[span]; colgroup[span]; table[border, cellpadding, ", "cellspacing]{width}; tbody td[colspan, headers, rowspan]{*}; ", "th[abbr, colspan, headers, rowspan, scope, sorted]{*}; thead tr;"});
    }

    private String _getAllowedContentText() {
        return "b blockquote cite code em h1 h2 h3 h4 h5 h6 hr i pre s strike strong u;";
    }

    private JSONObject _getStyleFormatJSONObject(String styleFormatName, String element, String cssClass) {
        JSONObject styleJSONObject = this._jsonFactory.createJSONObject();
        if (Validator.isNotNull((String)cssClass)) {
            JSONObject attributesJSONObject = JSONUtil.put((String)"class", (Object)cssClass);
            styleJSONObject.put("attributes", attributesJSONObject);
        }
        styleJSONObject.put("element", element).put("name", styleFormatName);
        return styleJSONObject;
    }

    private JSONArray _getStyleFormatsJSONArray(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)locale, (String)"com.liferay.frontend.editor.lang");
        return JSONUtil.putAll((Object[])new Object[]{this._getStyleFormatJSONObject(this._language.get(resourceBundle, "normal"), "p", null), this._getStyleFormatJSONObject(this._language.format(resourceBundle, "heading-x", (Object)"1"), "h1", null), this._getStyleFormatJSONObject(this._language.format(resourceBundle, "heading-x", (Object)"2"), "h2", null), this._getStyleFormatJSONObject(this._language.format(resourceBundle, "heading-x", (Object)"3"), "h3", null), this._getStyleFormatJSONObject(this._language.format(resourceBundle, "heading-x", (Object)"4"), "h4", null), this._getStyleFormatJSONObject(this._language.get(resourceBundle, "preformatted-text"), "pre", null), this._getStyleFormatJSONObject(this._language.get(resourceBundle, "cited-work"), "cite", null), this._getStyleFormatJSONObject(this._language.get(resourceBundle, "computer-code"), "code", null), this._getStyleFormatJSONObject(this._language.get(resourceBundle, "info-message"), "div", "overflow-auto portlet-msg-info"), this._getStyleFormatJSONObject(this._language.get(resourceBundle, "alert-message"), "div", "overflow-auto portlet-msg-alert"), this._getStyleFormatJSONObject(this._language.get(resourceBundle, "error-message"), "div", "overflow-auto portlet-msg-error")});
    }

    private void _populateFileBrowserURL(JSONObject jsonObject, RequestBackedPortletURLFactory requestBackedPortletURLFactory, String eventName) {
        BlogsItemSelectorCriterion blogsItemSelectorCriterion = new BlogsItemSelectorCriterion();
        blogsItemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new FileEntryItemSelectorReturnType(), new URLItemSelectorReturnType()});
        ImageItemSelectorCriterion imageItemSelectorCriterion = new ImageItemSelectorCriterion();
        imageItemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new FileEntryItemSelectorReturnType(), new URLItemSelectorReturnType()});
        URLItemSelectorCriterion urlItemSelectorCriterion = new URLItemSelectorCriterion();
        urlItemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new URLItemSelectorReturnType()});
        PortletURL itemSelectorURL = this._itemSelector.getItemSelectorURL(requestBackedPortletURLFactory, eventName, new ItemSelectorCriterion[]{blogsItemSelectorCriterion, imageItemSelectorCriterion, urlItemSelectorCriterion});
        jsonObject.put("filebrowserImageBrowseLinkUrl", itemSelectorURL.toString()).put("filebrowserImageBrowseUrl", itemSelectorURL.toString());
    }

    private void _populateTwitterButton(JSONObject jsonObject) {
        JSONObject toolbarsJSONObject = jsonObject.getJSONObject("toolbars");
        if (toolbarsJSONObject == null) {
            return;
        }
        JSONObject toolbarsStylesJSONObject = toolbarsJSONObject.getJSONObject("styles");
        if (toolbarsStylesJSONObject == null) {
            return;
        }
        JSONArray toolbarsStylesSelectionsJSONArray = toolbarsStylesJSONObject.getJSONArray("selections");
        if (toolbarsStylesSelectionsJSONArray == null) {
            return;
        }
        for (int i = 0; i < toolbarsStylesSelectionsJSONArray.length(); ++i) {
            JSONArray buttonsJSONArray;
            String toolbarsStylesSelectionsTest;
            JSONObject toolbarsStylesSelectionsJSONObject = toolbarsStylesSelectionsJSONArray.getJSONObject(i);
            if (toolbarsStylesSelectionsJSONObject == null || !(toolbarsStylesSelectionsTest = toolbarsStylesSelectionsJSONObject.getString("test")).equals("AlloyEditor.SelectionTest.text") || (buttonsJSONArray = toolbarsStylesSelectionsJSONObject.getJSONArray("buttons")) == null) continue;
            buttonsJSONArray.put("twitter");
            return;
        }
    }
}

