/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.editor.configuration.internal;

import com.liferay.blogs.item.selector.criterion.BlogsItemSelectorCriterion;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.FileEntryItemSelectorReturnType;
import com.liferay.item.selector.criteria.URLItemSelectorReturnType;
import com.liferay.item.selector.criteria.image.criterion.ImageItemSelectorCriterion;
import com.liferay.item.selector.criteria.upload.criterion.UploadItemSelectorCriterion;
import com.liferay.item.selector.criteria.url.criterion.URLItemSelectorCriterion;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.editor.configuration.BaseEditorConfigContributor;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"editor.config.key=contentEditor", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAdminPortlet"}, service={EditorConfigContributor.class})
public class BlogsContentEditorConfigContributor
extends BaseEditorConfigContributor {
    @Reference
    private ItemSelector _itemSelector;

    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        StringBundler sb = new StringBundler(6);
        sb.append("a[*](*); ");
        sb.append(this.getAllowedContentText());
        sb.append(" div[*](*); iframe[*](*); img[*](*){*}; ");
        sb.append(this.getAllowedContentLists());
        sb.append(" p {text-align}; ");
        sb.append(this.getAllowedContentTable());
        jsonObject.put("allowedContent", sb.toString());
        String namespace = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:namespace"));
        String name = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:name"));
        this.populateFileBrowserURL(jsonObject, themeDisplay, requestBackedPortletURLFactory, namespace + name + "selectItem");
        this._populateTwitterButton(jsonObject);
    }

    protected String getAllowedContentLists() {
        return "li ol ul;";
    }

    protected String getAllowedContentTable() {
        return "table[border, cellpadding, cellspacing] {width}; tbody td th[scope]; thead tr[scope];";
    }

    protected String getAllowedContentText() {
        return "b code em h1 h2 h3 h4 h5 h6 hr i pre strong u;";
    }

    protected void populateFileBrowserURL(JSONObject jsonObject, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory, String eventName) {
        BlogsItemSelectorCriterion blogsItemSelectorCriterion = new BlogsItemSelectorCriterion();
        blogsItemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new FileEntryItemSelectorReturnType(), new URLItemSelectorReturnType()});
        ImageItemSelectorCriterion imageItemSelectorCriterion = new ImageItemSelectorCriterion();
        imageItemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new FileEntryItemSelectorReturnType(), new URLItemSelectorReturnType()});
        URLItemSelectorCriterion urlItemSelectorCriterion = new URLItemSelectorCriterion();
        urlItemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new URLItemSelectorReturnType()});
        PortletURL uploadURL = requestBackedPortletURLFactory.createActionURL("com_liferay_blogs_web_portlet_BlogsPortlet");
        uploadURL.setParameter("javax.portlet.action", "/blogs/upload_image");
        String[] extensions = PropsUtil.getArray((String)"blogs.image.extensions");
        UploadItemSelectorCriterion uploadItemSelectorCriterion = new UploadItemSelectorCriterion("com_liferay_blogs_web_portlet_BlogsPortlet", uploadURL.toString(), LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"blog-images"), PropsValues.BLOGS_IMAGE_MAX_SIZE, extensions);
        uploadItemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new FileEntryItemSelectorReturnType()});
        PortletURL itemSelectorURL = this._itemSelector.getItemSelectorURL(requestBackedPortletURLFactory, eventName, new ItemSelectorCriterion[]{blogsItemSelectorCriterion, imageItemSelectorCriterion, urlItemSelectorCriterion, uploadItemSelectorCriterion});
        jsonObject.put("filebrowserImageBrowseLinkUrl", itemSelectorURL.toString());
        jsonObject.put("filebrowserImageBrowseUrl", itemSelectorURL.toString());
    }

    private void _populateTwitterButton(JSONObject jsonObject) {
        JSONObject toolbarsJSONObject = jsonObject.getJSONObject("toolbars");
        if (toolbarsJSONObject == null) {
            return;
        }
        JSONObject toolbarsStylesJSONObject = toolbarsJSONObject.getJSONObject("styles");
        if (toolbarsStylesJSONObject == null) {
            return;
        }
        JSONArray toolbarsStylesSelectionsJSONArray = toolbarsStylesJSONObject.getJSONArray("selections");
        if (toolbarsStylesSelectionsJSONArray == null) {
            return;
        }
        for (int i = 0; i < toolbarsStylesSelectionsJSONArray.length(); ++i) {
            JSONArray buttonsJSONArray;
            String toolbarsStylesSelectionsTest;
            JSONObject toolbarsStylesSelectionsJSONObject = toolbarsStylesSelectionsJSONArray.getJSONObject(i);
            if (toolbarsStylesSelectionsJSONObject == null || !(toolbarsStylesSelectionsTest = toolbarsStylesSelectionsJSONObject.getString("test")).equals("AlloyEditor.SelectionTest.text") || (buttonsJSONArray = toolbarsStylesSelectionsJSONObject.getJSONArray("buttons")) == null) continue;
            buttonsJSONArray.put("twitter");
            return;
        }
    }
}

