/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.batch.planner.model.impl;

import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.service.BatchPlannerPlanLocalServiceUtil;

/**
 * The extended model base implementation for the BatchPlannerPlan service. Represents a row in the &quot;BatchPlannerPlan&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BatchPlannerPlanImpl}.
 * </p>
 *
 * @author Igor Beslic
 * @see BatchPlannerPlanImpl
 * @see BatchPlannerPlan
 * @generated
 */
public abstract class BatchPlannerPlanBaseImpl
	extends BatchPlannerPlanModelImpl implements BatchPlannerPlan {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a batch planner plan model instance should use the <code>BatchPlannerPlan</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			BatchPlannerPlanLocalServiceUtil.addBatchPlannerPlan(this);
		}
		else {
			BatchPlannerPlanLocalServiceUtil.updateBatchPlannerPlan(this);
		}
	}

}