/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.internal.notifications;

import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;

public class BatchPlannerNotificationSender {
    private static final Log _log = LogFactoryUtil.getLog(BatchPlannerNotificationSender.class);
    private final String _taskType;
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public BatchPlannerNotificationSender(String taskType) {
        this._taskType = taskType;
    }

    public JSONObject getNotificationEventJSONObject(BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus, long batchPlannerPlanId, String className) {
        JSONObject notificationEventJSONObject = JSONFactoryUtil.createJSONObject();
        return notificationEventJSONObject.put("batchPlannerPlanId", batchPlannerPlanId).put("className", className).put("status", batchEngineTaskExecuteStatus.name()).put("taskType", this._taskType);
    }

    public JSONObject getNotificationEventJSONObject(BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus, long batchPlannerPlanId, String className, String fileName) {
        JSONObject notificationEventJSONObject = this.getNotificationEventJSONObject(batchEngineTaskExecuteStatus, batchPlannerPlanId, className);
        return notificationEventJSONObject.put("fileName", fileName);
    }

    public void sendUserNotificationEvents(long userId, String portletId, int notificationType, JSONObject jsonObject) {
        try {
            this._userNotificationEventLocalService.sendUserNotificationEvents(userId, portletId, notificationType, jsonObject);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to send user notification", (Throwable)exception);
        }
    }

    public void setUserNotificationEventLocalService(UserNotificationEventLocalService userNotificationEventLocalService) {
        this._userNotificationEventLocalService = userNotificationEventLocalService;
    }
}

