/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.service.impl;

import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.BatchEngineTaskItemDelegateRegistry;
import com.liferay.batch.engine.exception.BatchEngineImportTaskParametersException;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.base.BatchEngineImportTaskLocalServiceBaseImpl;
import com.liferay.batch.engine.service.persistence.BatchEngineImportTaskErrorPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.batch.engine.model.BatchEngineImportTask"}, service={AopService.class})
public class BatchEngineImportTaskLocalServiceImpl
extends BatchEngineImportTaskLocalServiceBaseImpl {
    private static final String _INVALID_ENCLOSING_CHARACTERS = "'\"";
    @Reference
    private BatchEngineImportTaskErrorPersistence _batchEngineImportTaskErrorPersistence;
    @Reference
    private BatchEngineTaskItemDelegateRegistry _batchEngineTaskItemDelegateRegistry;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BatchEngineImportTask addBatchEngineImportTask(String externalReferenceCode, long companyId, long userId, long batchSize, String callbackURL, String className, byte[] content, String contentType, String executeStatus, Map<String, String> fieldNameMappingMap, int importStrategy, String operation, Map<String, Serializable> parameters, String taskItemDelegateName) throws PortalException {
        if (parameters != null && !parameters.isEmpty()) {
            this._validateDelimiter(parameters.getOrDefault("delimiter", null));
            this._validateEnclosingCharacter(parameters.getOrDefault("enclosingCharacter", null));
            this._validateStrategies(className, taskItemDelegateName, parameters.getOrDefault("createStrategy", null), parameters.getOrDefault("updateStrategy", null));
        }
        BatchEngineImportTask batchEngineImportTask = this.batchEngineImportTaskPersistence.create(this.counterLocalService.increment(BatchEngineImportTask.class.getName()));
        batchEngineImportTask.setExternalReferenceCode(externalReferenceCode);
        batchEngineImportTask.setCompanyId(companyId);
        batchEngineImportTask.setUserId(userId);
        batchEngineImportTask.setBatchSize(batchSize);
        batchEngineImportTask.setCallbackURL(callbackURL);
        batchEngineImportTask.setClassName(className);
        batchEngineImportTask.setContent((Blob)new OutputBlob((InputStream)new UnsyncByteArrayInputStream(content), (long)content.length));
        batchEngineImportTask.setContentType(contentType);
        batchEngineImportTask.setExecuteStatus(executeStatus);
        if (fieldNameMappingMap != null && !fieldNameMappingMap.isEmpty()) {
            batchEngineImportTask.setFieldNameMapping(fieldNameMappingMap);
        }
        batchEngineImportTask.setImportStrategy(importStrategy);
        batchEngineImportTask.setOperation(operation);
        batchEngineImportTask.setParameters(parameters);
        batchEngineImportTask.setTaskItemDelegateName(taskItemDelegateName);
        return (BatchEngineImportTask)this.batchEngineImportTaskPersistence.update((BaseModel)batchEngineImportTask);
    }

    @Override
    public BatchEngineImportTask deleteBatchEngineImportTask(long batchEngineImportTaskId) throws PortalException {
        this._batchEngineImportTaskErrorPersistence.removeByBatchEngineImportTaskId(batchEngineImportTaskId);
        return this.batchEngineImportTaskPersistence.remove(batchEngineImportTaskId);
    }

    public List<BatchEngineImportTask> getBatchEngineImportTasks(long companyId, int start, int end) {
        return this.batchEngineImportTaskPersistence.findByCompanyId(companyId, start, end);
    }

    public List<BatchEngineImportTask> getBatchEngineImportTasks(long companyId, int start, int end, OrderByComparator<BatchEngineImportTask> orderByComparator) {
        return this.batchEngineImportTaskPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public List<BatchEngineImportTask> getBatchEngineImportTasks(String executeStatus) {
        return this.batchEngineImportTaskPersistence.findByExecuteStatus(executeStatus);
    }

    public int getBatchEngineImportTasksCount(long companyId) {
        return this.batchEngineImportTaskPersistence.countByCompanyId(companyId);
    }

    private void _validateDelimiter(String delimiter) throws BatchEngineImportTaskParametersException {
        if (Validator.isNull((String)delimiter)) {
            return;
        }
        if (_INVALID_ENCLOSING_CHARACTERS.contains(delimiter)) {
            throw new BatchEngineImportTaskParametersException("Illegal delimiter value " + delimiter);
        }
    }

    private void _validateEnclosingCharacter(String enclosingCharacter) throws BatchEngineImportTaskParametersException {
        if (Validator.isNull((String)enclosingCharacter)) {
            return;
        }
        if (!_INVALID_ENCLOSING_CHARACTERS.contains(enclosingCharacter)) {
            throw new BatchEngineImportTaskParametersException("Illegal enclosing character value " + enclosingCharacter);
        }
    }

    private void _validateStrategies(String className, String taskItemDelegateName, String createStrategy, String updateStrategy) throws BatchEngineImportTaskParametersException {
        BatchEngineTaskItemDelegate batchEngineTaskItemDelegate = this._batchEngineTaskItemDelegateRegistry.getBatchEngineTaskItemDelegate(className, taskItemDelegateName);
        if (Validator.isNotNull((String)createStrategy) && !batchEngineTaskItemDelegate.hasCreateStrategy(createStrategy)) {
            throw new BatchEngineImportTaskParametersException("Illegal create strategy " + createStrategy);
        }
        if (Validator.isNotNull((String)updateStrategy) && !batchEngineTaskItemDelegate.hasUpdateStrategy(updateStrategy)) {
            throw new BatchEngineImportTaskParametersException("Illegal update strategy " + updateStrategy);
        }
    }
}

