/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.liferay.batch.engine.internal.writer.BatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.ColumnValuesExtractor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XLSBatchEngineExportTaskItemWriterImpl
implements BatchEngineExportTaskItemWriter {
    private final ColumnValuesExtractor _columnValuesExtractor;
    private final OutputStream _outputStream;
    private int _rowNum;
    private final Sheet _sheet;
    private final Workbook _workbook = new XSSFWorkbook();

    public XLSBatchEngineExportTaskItemWriterImpl(Map<String, Field> fieldsMap, List<String> fieldNames, OutputStream outputStream) {
        if (fieldNames.isEmpty()) {
            throw new IllegalArgumentException("Field names are not set");
        }
        this._outputStream = outputStream;
        this._columnValuesExtractor = new ColumnValuesExtractor(fieldsMap, fieldNames);
        this._sheet = this._workbook.createSheet();
        this._write(this._columnValuesExtractor.getHeaders());
    }

    @Override
    public void close() throws IOException {
        this._workbook.write(this._outputStream);
        this._workbook.close();
        this._outputStream.close();
    }

    @Override
    public void write(Collection<?> items) throws Exception {
        for (Object item : items) {
            for (Object[] values : this._columnValuesExtractor.extractValues(item)) {
                this._write(values);
            }
        }
    }

    private void _write(Object[] values) {
        Row row = this._sheet.createRow(this._rowNum++);
        int column = 0;
        for (Object value : values) {
            Cell cell = row.createCell(column++);
            if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Date) {
                CellStyle cellStyle = this._workbook.createCellStyle();
                CreationHelper creationHelper = this._workbook.getCreationHelper();
                DataFormat dataFormat = creationHelper.createDataFormat();
                cellStyle.setDataFormat(dataFormat.getFormat("yyyy-mm-dd hh:mm:ss"));
                cell.setCellStyle(cellStyle);
                cell.setCellValue((Date)value);
                continue;
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                cell.setCellValue(number.doubleValue());
                continue;
            }
            cell.setCellValue((String)value);
        }
    }
}

