/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.memory.FinalizeManager;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;

public class ItemClassIndexUtil {
    private static final Map<Class<?>, Map<String, Field>> _fieldsMap = new ConcurrentReferenceKeyHashMap((ConcurrentMap)new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY), FinalizeManager.WEAK_REFERENCE_FACTORY);
    private static final List<Class<?>> _objectTypes = Arrays.asList(Boolean.class, BigDecimal.class, BigInteger.class, Byte.class, Date.class, Double.class, Float.class, Integer.class, Long.class, String.class);

    public static Map<String, Field> index(Class<?> itemClass) {
        LinkedList queue = new LinkedList();
        Map fieldsMap = _fieldsMap.computeIfAbsent(itemClass, clazz -> ItemClassIndexUtil._index(clazz, queue));
        while ((itemClass = (Class)queue.poll()) != null) {
            _fieldsMap.computeIfAbsent(itemClass, clazz -> ItemClassIndexUtil._index(clazz, queue));
        }
        return fieldsMap;
    }

    public static boolean isIterable(Class<?> valueClass) {
        return valueClass.isArray() || Collection.class.isAssignableFrom(valueClass);
    }

    public static boolean isListEntry(Object object) {
        return object instanceof ListEntry;
    }

    public static boolean isMap(Class<?> clazz) {
        return Objects.equals(clazz, Map.class);
    }

    public static boolean isMultidimensionalArray(Class<?> clazz) {
        if (!clazz.isArray()) {
            return false;
        }
        Class<?> componentTypeClass = clazz.getComponentType();
        return componentTypeClass.isArray();
    }

    public static boolean isObjectEntryProperties(Field field) {
        return field != null && Objects.equals(field.getDeclaringClass(), ObjectEntry.class) && Objects.equals(field.getType(), Map.class);
    }

    public static boolean isSingleColumnAdoptableArray(Class<?> clazz) {
        if (!clazz.isArray()) {
            return false;
        }
        return ItemClassIndexUtil.isSingleColumnAdoptableValue(clazz.getComponentType());
    }

    public static boolean isSingleColumnAdoptableValue(Class<?> clazz) {
        return clazz.isPrimitive() || _objectTypes.contains(clazz) || Enum.class.isAssignableFrom(clazz);
    }

    private static Map<String, Field> _index(Class<?> clazz, Queue<Class<?>> queue) {
        HashMap<String, Field> fieldsMap = new HashMap<String, Field>();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                if (ItemClassIndexUtil.isMultidimensionalArray(field.getType())) continue;
                field.setAccessible(true);
                String name = field.getName();
                if (name.charAt(0) == '_') {
                    name = name.substring(1);
                }
                if (field.isSynthetic()) continue;
                fieldsMap.put(name, field);
                Class<?> fieldClass = field.getType();
                if (ItemClassIndexUtil.isIterable(fieldClass) || ItemClassIndexUtil.isMap(fieldClass) || ItemClassIndexUtil.isSingleColumnAdoptableArray(fieldClass) || ItemClassIndexUtil.isSingleColumnAdoptableValue(fieldClass) || Objects.equals(clazz, fieldClass)) continue;
                queue.add(clazz);
            }
            if (Objects.equals(clazz.getSuperclass(), clazz.getDeclaringClass())) break;
            clazz = clazz.getSuperclass();
        }
        return fieldsMap;
    }
}

